/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDataSynchronizationConsumerProcess;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyIdentityFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.esr.service.RegistrySearchResultBean;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.List;
import org.apache.commons.lang.Validate;

public class HECLegacyDataSynchronizationConsumerSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private DataFileProcessExecutionContext context;
    private List acquiredData;
    private Builder mergeBuilder;
    private PersonService personService;
    private RegistryService registryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask started");
        }
        HECLegacyIdentityFileData identityData = (HECLegacyIdentityFileData)((Object)this.acquiredData.get(0));
        try {
            if (identityData.isPersonUpdate()) {
                Person person = this.matchPerson(identityData);
                this.overlayFileDataOnPerson(person, this.acquiredData, identityData.isCommsOnly());
                if (!identityData.isCommsOnly()) {
                    this.executeRules(person);
                }
            } else {
                Registry registry = this.matchRegistry(identityData);
                this.overlayFileDataOnRegistry(registry, this.acquiredData);
                this.registryService.updateRegistry(registry);
            }
            this.context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
        }
        catch (Exception e) {
            this.handleFailure(this.context, identityData, e);
        }
        finally {
            Object threadCreator;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask ended");
            }
            HECLegacyDataSynchronizationConsumerProcess.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
            Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
            synchronized (object) {
                threadCreator.notifyAll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HECLegacyDataSynchronizationConsumerSpawnedThreadTask notified creator");
            }
            this.context = null;
        }
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void overlayFileDataOnPerson(Person person, List acquiredData, boolean isCommsOnly) throws Exception {
        Object[] args = new Object[]{person, acquiredData, isCommsOnly};
        this.mergeBuilder.build((Object)args);
    }

    private void overlayFileDataOnRegistry(Registry registry, List acquiredData) throws Exception {
        Object[] args = new Object[3];
        args[0] = registry;
        args[1] = acquiredData;
        this.mergeBuilder.build((Object)args);
    }

    private void executeRules(Person person) throws ServiceException {
        this.personService.processDataSyncFromHECLegacy(person);
    }

    private Person matchPerson(HECLegacyIdentityFileData identityData) throws Exception {
        Person person;
        VPIDEntityKey vpid = CommonEntityKeyFactory.createVPIDEntityKey(identityData.getICN());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving Person by short-form VPID (ICN): " + vpid));
        }
        if ((person = this.personService.getPerson(vpid)) == null) {
            throw new RuntimeException("Unable to find Person for VPID: " + vpid);
        }
        return person;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Registry matchRegistry(HECLegacyIdentityFileData identityData) throws Exception {
        RegistrySearchCriteria query = new RegistrySearchCriteria();
        query.setSsn(identityData.getSSN());
        query.setLastName(identityData.getLegalName().getFamilyName());
        query.setFirstName(identityData.getLegalName().getGivenName());
        query.setRegistryType(identityData.getRegistryType());
        Registry onFile = null;
        List registryData = this.registryService.search(query);
        if (registryData.size() == 0) {
            if (identityData.getRegistryType() == null) throw new IllegalStateException("Unable to find a matching Registry entry in ESR...unable to create a new one since HECLegacy sent null for RegistryType");
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Unable to find a matching Registry entry in ESR.....creating a new one");
            }
            if (identityData.getRegistryType().isPrisonerOfWar()) {
                onFile = new PrisonerOfWar();
            } else {
                if (!identityData.getRegistryType().isPurpleHeart()) throw new IllegalStateException("Unable to find a matching Registry entry in ESR...unable to create a new one unsupported RegistryType");
                onFile = new PurpleHeart();
            }
        } else {
            if (registryData.size() == 1) {
                RegistrySearchResultBean searchResult = (RegistrySearchResultBean)registryData.get(0);
                return this.registryService.getRegistryById(searchResult.getEntityKey(), searchResult.getRegistryType());
            }
            if (registryData.size() <= 1) return onFile;
            throw new IllegalStateException("Can not find a singular match by Registry traits");
        }
        onFile.setRegistryTrait(new RegistryTrait());
        onFile.getRegistryTrait().setRegistryType(identityData.getRegistryType());
        return onFile;
    }

    private void handleFailure(DataFileProcessExecutionContext context, HECLegacyIdentityFileData identityData, Exception e) {
        String exceptionText = null;
        if (e == null) {
            exceptionText = "Error: Unable to synchronize data for identity data: " + (Object)((Object)identityData);
        } else if (e instanceof BuilderException) {
            Throwable cause = e.getCause();
            Throwable causesCause = cause != null ? cause.getCause() : null;
            exceptionText = "Error: Unable to synchronize data for identity data: " + (Object)((Object)identityData) + " because of BuilderException with cause: " + cause + " and causes cause: " + causesCause;
        } else {
            exceptionText = "Error: Unable to synchronize data for identity data: " + (Object)((Object)identityData) + " because of exception: " + e;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(identityData);
        context.getExceptionData().add(exceptionText + "\n\n");
    }

    public List getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(List acquiredData) {
        this.acquiredData = acquiredData;
    }

    public DataFileProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataFileProcessExecutionContext context) {
        this.context = context;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.personService, (String)"personService can not be null");
        Validate.notNull((Object)this.registryService, (String)"registryService can not be null");
        Validate.notNull((Object)this.mergeBuilder, (String)"mergeBuilder can not be null");
    }

    public Builder getMergeBuilder() {
        return this.mergeBuilder;
    }

    public void setMergeBuilder(Builder mergeBuilder) {
        this.mergeBuilder = mergeBuilder;
    }
}

