/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ExceptionWriterProcessCompletedHandler;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class HECLegacyDataSynchronizationConsumerProcessCompletedHandler
extends ExceptionWriterProcessCompletedHandler {
    private static String DATE_FORMAT = "yyyyMMddHHmmss";

    protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
        File inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile();
        String inputFileName = inputFile.getName();
        String root = new StringTokenizer(inputFileName, ".").nextToken();
        StringTokenizer st = new StringTokenizer(root, "_");
        String date = null;
        while (st.hasMoreTokens()) {
            date = st.nextToken();
        }
        date = StringUtils.rightPad((String)date, (int)DATE_FORMAT.length(), (char)'0');
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("File name [" + inputFileName + "] does not contain a date that is parsable to " + DATE_FORMAT);
        }
    }

    public void dataProcessingComplete(DataProcessExecutionContext context) {
        this.appendExceptionData(context);
        if (!context.isInterrupted() && context instanceof DataFileProcessExecutionContext) {
            File inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile();
            if (this.isDeleteInputFile() && !inputFile.delete()) {
                throw new IllegalStateException("Unable to delete input file: " + inputFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendExceptionData(DataProcessExecutionContext context) {
        List exceptionData = context.getExceptionData();
        if (exceptionData != null && !exceptionData.isEmpty()) {
            ArrayList currentExceptionData = new ArrayList(exceptionData);
            List list = exceptionData;
            synchronized (list) {
                exceptionData.clear();
            }
            this.getFileWriter().appendData(currentExceptionData, this.getExceptionFileNameSuffixData(context));
        }
    }
}

