/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDataSynchronizationConsumerProcessCompletedHandler;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDataSynchronizationConsumerSpawnedThreadTask;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyIdentityFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.esr.service.RegistrySearchResultBean;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.fw.batchprocess.AbstractDataFileMREProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.ThreadPool;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class HECLegacyDataSynchronizationConsumerProcess
extends AbstractDataFileMREProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 500;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    public static final String HECLEGACY_DATASYNC_CONSUMER_THREAD_NAME = "HECLEGACYCONSUMERTHREAD";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 500;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;
    private PersonService personService;
    private RegistryService registryService;
    private Builder mergeBuilder;

    protected boolean isNewEntityRow(String rowRawData) {
        return StringUtils.isNotBlank((String)rowRawData) ? rowRawData.startsWith("IDT") : false;
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("HECLegacyDataSynchronizationConsumerSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataFileProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        HECLegacyDataSynchronizationConsumerProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(HECLegacyDataSynchronizationConsumerProcess.getTaskCount(context) + adjustment));
        }
    }

    public void processEntityData(DataFileProcessExecutionContext context, List acquiredData) {
        if (this.isThreaded()) {
            this.spawnThread(context, acquiredData);
        } else {
            HECLegacyIdentityFileData identityData = (HECLegacyIdentityFileData)((Object)acquiredData.get(0));
            try {
                if (identityData.isPersonUpdate()) {
                    Person person = this.matchPerson(identityData);
                    this.overlayFileDataOnPerson(person, acquiredData, identityData.isCommsOnly());
                    if (!identityData.isCommsOnly()) {
                        this.executeRules(person);
                    }
                } else {
                    Registry registry = this.matchRegistry(identityData);
                    this.overlayFileDataOnRegistry(registry, acquiredData);
                    this.registryService.updateRegistry(registry);
                }
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
            }
            catch (Exception e) {
                this.handleFailure(context, identityData, e);
            }
        }
        if (this.shouldWriteExceptionData(context)) {
            ((HECLegacyDataSynchronizationConsumerProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
        }
    }

    private boolean shouldWriteExceptionData(DataFileProcessExecutionContext context) {
        int exceptionDataSize;
        int n = exceptionDataSize = context.getExceptionData() == null ? 0 : context.getExceptionData().size();
        return exceptionDataSize != 0 ? exceptionDataSize % 20 == 0 : false;
    }

    private void overlayFileDataOnPerson(Person person, List acquiredData, boolean isCommsOnly) throws Exception {
        Object[] args = new Object[]{person, acquiredData, isCommsOnly};
        this.mergeBuilder.build((Object)args);
    }

    private void overlayFileDataOnRegistry(Registry registry, List acquiredData) throws Exception {
        Object[] args = new Object[3];
        args[0] = registry;
        args[1] = acquiredData;
        this.mergeBuilder.build((Object)args);
    }

    private void executeRules(Person person) throws ServiceException {
        this.personService.processDataSyncFromHECLegacy(person);
    }

    private Person matchPerson(HECLegacyIdentityFileData identityData) throws Exception {
        Person person;
        VPIDEntityKey vpid = CommonEntityKeyFactory.createVPIDEntityKey(identityData.getICN());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving Person by short-form VPID (ICN): " + vpid));
        }
        if ((person = this.personService.getPerson(vpid)) == null) {
            throw new RuntimeException("Unable to find Person for VPID: " + vpid);
        }
        return person;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Registry matchRegistry(HECLegacyIdentityFileData identityData) throws Exception {
        RegistrySearchCriteria query = new RegistrySearchCriteria();
        query.setSsn(identityData.getSSN());
        query.setLastName(identityData.getLegalName().getFamilyName());
        query.setFirstName(identityData.getLegalName().getGivenName());
        query.setRegistryType(identityData.getRegistryType());
        Registry onFile = null;
        List registryData = this.registryService.search(query);
        if (registryData.size() == 0) {
            if (identityData.getRegistryType() == null) throw new IllegalStateException("Unable to find a matching Registry entry in ESR...unable to create a new one since HECLegacy sent null for RegistryType");
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Unable to find a matching Registry entry in ESR.....creating a new one");
            }
            if (identityData.getRegistryType().isPrisonerOfWar()) {
                onFile = new PrisonerOfWar();
            } else {
                if (!identityData.getRegistryType().isPurpleHeart()) throw new IllegalStateException("Unable to find a matching Registry entry in ESR...unable to create a new one unsupported RegistryType");
                onFile = new PurpleHeart();
            }
        } else {
            if (registryData.size() == 1) {
                RegistrySearchResultBean searchResult = (RegistrySearchResultBean)registryData.get(0);
                return this.registryService.getRegistryById(searchResult.getEntityKey(), searchResult.getRegistryType());
            }
            if (registryData.size() <= 1) return onFile;
            throw new IllegalStateException("Can not find a singular match by Registry traits");
        }
        onFile.setRegistryTrait(new RegistryTrait());
        onFile.getRegistryTrait().setRegistryType(identityData.getRegistryType());
        return onFile;
    }

    private void handleFailure(DataFileProcessExecutionContext context, HECLegacyIdentityFileData identityData, Exception e) {
        String exceptionText = null;
        if (e == null) {
            exceptionText = "Error: Unable to synchronize data for identity data: " + (Object)((Object)identityData);
        } else if (e instanceof BuilderException) {
            Throwable cause = e.getCause();
            Throwable causesCause = cause != null ? cause.getCause() : null;
            exceptionText = "Error: Unable to synchronize data for identity data: " + (Object)((Object)identityData) + " because of BuilderException with cause: " + cause + " and causes cause: " + causesCause;
        } else {
            exceptionText = "Error: Unable to synchronize data for identity data: " + (Object)((Object)identityData) + " because of exception: " + e;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(identityData);
        context.getExceptionData().add(exceptionText + "\n\n");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService);
        Validate.notNull((Object)this.registryService);
        Validate.notNull((Object)this.mergeBuilder);
    }

    public Builder getMergeBuilder() {
        return this.mergeBuilder;
    }

    public void setMergeBuilder(Builder mergeBuilder) {
        this.mergeBuilder = mergeBuilder;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    private boolean isThreaded() {
        return StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block10: {
            if (this.isThreaded()) {
                try {
                    if (HECLegacyDataSynchronizationConsumerProcess.getTaskCount(context) == 0) break block10;
                    HECLegacyDataSynchronizationConsumerProcess hECLegacyDataSynchronizationConsumerProcess = this;
                    synchronized (hECLegacyDataSynchronizationConsumerProcess) {
                        boolean stillProcessing = true;
                        while (stillProcessing) {
                            ((Object)((Object)this)).wait();
                            if (HECLegacyDataSynchronizationConsumerProcess.getTaskCount(context) != 0) continue;
                            stillProcessing = false;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.throwIllegalStateException("HECLegacyDataSynchronizationConsumerProcess was interrupted while it was waiting for its spawned threads to complete", e);
                }
                finally {
                    this.getThreadPool(context).stop();
                    this.cleanThreadPool(context);
                }
            }
        }
        super.handleDataProcessCompleted(context);
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
    }

    private void spawnThread(DataFileProcessExecutionContext context, List acquiredData) {
        try {
            while (HECLegacyDataSynchronizationConsumerProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            HECLegacyDataSynchronizationConsumerSpawnedThreadTask task = (HECLegacyDataSynchronizationConsumerSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAuditInfo(this.getAuditInfo());
            task.setAcquiredData(acquiredData);
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("HECLegacyDataSynchronizationConsumerProcess was interrupted while it was spawning a thread. ", e);
        }
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }
}

