/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.UnexpectedEnrollmentException;
import gov.va.med.esr.common.batchprocess.UnexpectedEnrollmentStatusException;
import gov.va.med.esr.common.batchprocess.VeteranUpdaterProcess;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.rule.parameter.CommunicationsInputParameter;
import gov.va.med.esr.common.rule.service.CommunicationRuleService;
import gov.va.med.esr.common.rule.service.EligibilityEnrollmentRuleService;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.common.util.FeedbackTask;
import gov.va.med.esr.common.util.TimerFactory;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonLockedException;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerAware;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.io.IOException;
import java.util.Timer;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class VeteranUpdaterProcessImpl
implements BeanFactoryAware,
VeteranUpdaterProcess {
    private int delay = 30000;
    private BeanFactory beanFactory;
    private Log logStatus;
    private HttpServletResponse httpServletResponse;
    private JspWriter jspWriter;
    private TimerFactory timerFactory;
    private PSDelegateService psDelegateService;
    private EligibilityEnrollmentRuleService eligibilityEnrollmentRuleService;
    private CommunicationRuleService communicationRuleService;
    private TriggerRouter triggerRouter;
    private EventRuleService eventRuleService;
    private PersonService personService;
    private RuleValidationService ruleValidationService;

    public void setRuleValidationService(RuleValidationService ruleValidationService) {
        this.ruleValidationService = ruleValidationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public void setEligibilityEnrollmentRuleService(EligibilityEnrollmentRuleService eligibilityEnrollmentRuleService) {
        this.eligibilityEnrollmentRuleService = eligibilityEnrollmentRuleService;
    }

    public void setCommunicationRuleService(CommunicationRuleService communicationRuleService) {
        this.communicationRuleService = communicationRuleService;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public void setEventRuleService(EventRuleService eventRuleService) {
        this.eventRuleService = eventRuleService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public void setTimerFactory(TimerFactory timerFactory) {
        this.timerFactory = timerFactory;
    }

    public void setLogStatus(Log logStatus) {
        this.logStatus = logStatus;
    }

    @Override
    public void setResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public void setJspWriter(JspWriter jspWriter) {
        this.jspWriter = jspWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVeteran(String personId, String vpid, int indexOfPersonInResultSet) throws UnexpectedEnrollmentException, PersonLockedException, ServiceException, IOException, RuleException, UnexpectedEnrollmentStatusException {
        block6: {
            Timer timer = null;
            try {
                PersonIdEntityKey personEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(personId);
                Person personToProcess = this.personService.getPerson(personEntityKey);
                String processingVeteranMessage = "Processing veteran: " + (indexOfPersonInResultSet + 1) + " with person id: " + personId + " and vpid: " + vpid;
                this.jspWriter.println("<br/>" + processingVeteranMessage);
                this.httpServletResponse.flushBuffer();
                this.logStatus.info((Object)processingVeteranMessage);
                FeedbackTask feedbackTask = new FeedbackTask(this.jspWriter, this.httpServletResponse, ".");
                timer = this.timerFactory.scheduleTimerTask(feedbackTask, 0L, this.delay);
                Person calculatedPerson = this.eligibilityEnrollmentRuleService.determineEnrollmentNoTriggerLetters(personToProcess);
                timer.cancel();
                EnrollmentDetermination calculatedEnrollmentDetermination = calculatedPerson.getEnrollmentDetermination();
                if (calculatedEnrollmentDetermination.getPriorityGroup().getCodeObject() == EnrollmentPriorityGroup.GROUP_8 && calculatedEnrollmentDetermination.getPrioritySubGroup().getCodeObject() == EnrollmentPrioritySubGroup.SUBGROUP_E || calculatedEnrollmentDetermination.getPriorityGroup().getCodeObject() == EnrollmentPriorityGroup.GROUP_8 && calculatedEnrollmentDetermination.getPrioritySubGroup().getCodeObject() == EnrollmentPrioritySubGroup.SUBGROUP_G) break block6;
                if (calculatedEnrollmentDetermination.getPriorityGroup().getCodeObject() == EnrollmentPriorityGroup.GROUP_8 && (calculatedEnrollmentDetermination.getPrioritySubGroup().getCodeObject() == EnrollmentPrioritySubGroup.SUBGROUP_B || calculatedEnrollmentDetermination.getPrioritySubGroup().getCodeObject() == EnrollmentPrioritySubGroup.SUBGROUP_D)) {
                    if (calculatedEnrollmentDetermination.getEnrollmentStatus().getCodeObject() != EnrollmentStatus.CODE_VERIFIED) {
                        throw new UnexpectedEnrollmentStatusException();
                    }
                    calculatedEnrollmentDetermination.setInitialPriorityGroup(calculatedEnrollmentDetermination.getPriorityGroup());
                    calculatedEnrollmentDetermination.setInitialPrioritySubGroup(calculatedEnrollmentDetermination.getPrioritySubGroup());
                    String triggerLettersMessage = "Triggering letters";
                    this.jspWriter.println("<br/>" + triggerLettersMessage);
                    this.httpServletResponse.flushBuffer();
                    this.logStatus.info((Object)triggerLettersMessage);
                    feedbackTask = new FeedbackTask(this.jspWriter, this.httpServletResponse, ".");
                    timer = this.timerFactory.scheduleTimerTask(feedbackTask, 0L, this.delay);
                    this.communicationRuleService.triggerAutomaticLetters(calculatedPerson, null, false, null);
                    CommunicationsInputParameter communicationsInput = (CommunicationsInputParameter)this.beanFactory.getBean("communicationsRuleParameter");
                    communicationsInput.setResultData((AbstractEntity)calculatedPerson);
                    communicationsInput.setIncomingData((AbstractEntity)calculatedPerson);
                    communicationsInput.setPristineData((AbstractEntity)personToProcess);
                    communicationsInput.trigger623RLetter();
                    this.triggerRouter.processTriggerAware((TriggerAware)communicationsInput);
                    timer.cancel();
                    String processingEventsMessage = "Processing events and messages";
                    this.jspWriter.println("<br/>" + processingEventsMessage);
                    this.httpServletResponse.flushBuffer();
                    this.logStatus.info((Object)processingEventsMessage);
                    feedbackTask = new FeedbackTask(this.jspWriter, this.httpServletResponse, ".");
                    timer = this.timerFactory.scheduleTimerTask(feedbackTask, 0L, this.delay);
                    this.eventRuleService.handleCommonPostEvents(calculatedPerson, false);
                    timer.cancel();
                    String savingVeteranMessage = "Saving veteran to database";
                    this.jspWriter.println("<br/>" + savingVeteranMessage);
                    this.httpServletResponse.flushBuffer();
                    this.logStatus.info((Object)savingVeteranMessage);
                    feedbackTask = new FeedbackTask(this.jspWriter, this.httpServletResponse, ".");
                    timer = this.timerFactory.scheduleTimerTask(feedbackTask, 0L, this.delay);
                    this.personService.save(calculatedPerson);
                    timer.cancel();
                    break block6;
                }
                throw new UnexpectedEnrollmentException();
            }
            finally {
                if (timer != null) {
                    timer.cancel();
                }
            }
        }
    }

    @Override
    public void setDelay(int delay) {
        this.delay = delay;
    }
}

