/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.batchprocess.BatchProcessPersonIdentityTraits;
import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainer;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

public class VSSCFileData
extends BatchProcessPersonIdentityTraits
implements RawFileDataContainer {
    private static Class[] AUTO_REGISTER_CLASSES = new Class[]{CombatEpisode.class};
    private static final long serialVersionUID = -5955729754075793417L;
    private String icn = null;
    private CombatEpisode combatEpisode = null;
    private Date lastUpdateDate = null;

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        this.combatEpisode = new CombatEpisode();
        int i = 0;
        this.setFirstName(parsedRow.getString(i++));
        this.setMiddleInitial(parsedRow.getString(i++));
        this.setLastName(parsedRow.getString(i++));
        this.setSsn(parsedRow.getString(i++));
        this.setIcn(parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"dateOfBirth", (String)parsedRow.getString(i++));
        parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this.combatEpisode), (String)"startDate", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this.combatEpisode), (String)"endDate", (String)parsedRow.getString(i++));
        parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this.combatEpisode), (String)"combatPayType", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this.combatEpisode), (String)"conflictLocation", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this.combatEpisode), (String)"OEFOIFSource", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"lastUpdateDate", (String)parsedRow.getString(i++));
        if (!this.isDataValid()) {
            this.combatEpisode = null;
            throw new Exception(LoadVSSCDataResult.EXP_REQUIRED_FIELDS_MISSING_INVALID);
        }
        this.setDefaultDates();
        if (!this.isDataConsistent(this.combatEpisode)) {
            this.combatEpisode = null;
            throw new Exception(LoadVSSCDataResult.EXP_CONSISTENCY_CHECKS_FAILED);
        }
    }

    public OrderedMap getRawFileData() throws Exception {
        return null;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("icn", (Object)this.icn);
    }

    protected String transformLookup(Lookup lookup) {
        return lookup == null ? null : lookup.getCode();
    }

    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    private boolean isDataValid() {
        if (StringUtils.isEmpty((String)this.getLastName()) || StringUtils.isEmpty((String)this.getSsn()) || this.getDateOfBirth() == null || this.combatEpisode.getStartDate() == null || this.combatEpisode.getEndDate() == null || this.combatEpisode.getCombatPayType() == null || this.combatEpisode.getConflictLocation() == null || this.combatEpisode.getOEFOIFSource() == null || this.getLastUpdateDate() == null) {
            return false;
        }
        if (!this.combatEpisode.getStartDate().isMonthPrecise()) {
            return false;
        }
        return this.combatEpisode.getEndDate().isMonthPrecise();
    }

    private boolean isDataConsistent(CombatEpisode episode) {
        Date endDate;
        Date currentDate = DateUtils.getCurrentDate();
        Date startDate = episode.getStartDate().getCalendar().getTime();
        if (startDate.after(endDate = episode.getEndDate().getCalendar().getTime())) {
            return false;
        }
        if (startDate.after(currentDate) || endDate.after(currentDate)) {
            return false;
        }
        if (startDate.before(episode.getConflictLocation().getStartDate())) {
            return false;
        }
        if (ConflictLocation.CODE_OEF.getCode().equals(episode.getConflictLocation().getCode()) && endDate.before(this.getDate(2001, 9, 11))) {
            return false;
        }
        if (ConflictLocation.CODE_OIF.getCode().equals(episode.getConflictLocation().getCode()) && endDate.before(this.getDate(2003, 3, 19))) {
            return false;
        }
        return !ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(episode.getConflictLocation().getCode()) || !endDate.before(this.getDate(2001, 9, 11));
    }

    private Date getDate(int year, int month, int day) {
        return DateUtils.createCalendar((int)year, (int)month, (int)day).getTime();
    }

    private void setDefaultDates() {
        Calendar calendar;
        if (!this.combatEpisode.getStartDate().isDayPrecise()) {
            calendar = this.combatEpisode.getStartDate().getCalendar();
            calendar.set(5, 1);
            Calendar newDate = (Calendar)calendar.clone();
            newDate.clear();
            newDate.set(calendar.get(1), calendar.get(2), calendar.get(5));
            this.combatEpisode.setStartDate(new ImpreciseDate(newDate));
        }
        if (!this.combatEpisode.getEndDate().isDayPrecise()) {
            calendar = this.combatEpisode.getEndDate().getCalendar();
            int lastDay = calendar.getActualMaximum(5);
            calendar.set(5, lastDay);
            Calendar newDate = (Calendar)calendar.clone();
            newDate.clear();
            newDate.set(calendar.get(1), calendar.get(2), calendar.get(5));
            this.combatEpisode.setEndDate(new ImpreciseDate(newDate));
        }
    }

    public CombatEpisode getCombatEpisode() {
        return this.combatEpisode;
    }

    public void setCombatEpisode(CombatEpisode combatEpisode) {
        this.combatEpisode = combatEpisode;
    }

    public Class[] getClassesForAutoRegisterConverters() {
        return AUTO_REGISTER_CLASSES;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClasses((Class[])AUTO_REGISTER_CLASSES);
    }
}

