/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class UpdateEmptyCountryCodeProcess
extends AbstractDataQueryIncrementalProcess {
    private static final String UPDATE_COUNTRY_CODE = "updateEmptyCountryCode_updateCountry";
    private static final String PARAM_COUNTRY_CODE = "addressId";
    private static final String PARAM_CASEID = "caseId";
    private static final String CLOSE_WORKCASE = "updateEmptyCountryCodeProcess.closeWorkcase";
    LookupService lookupService;
    TransactionTimestampManager timestampManager;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Update Empty Country Code batch process: Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        WkfCaseStatusType closedStatusType = null;
        try {
            closedStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.CLOSED.getName());
        }
        catch (ServiceException ex) {
            String errMsg = "Error while executing Update Empty Country Code batch process";
            context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block13: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal wkfCaseId = (BigDecimal)row[0];
                BigDecimal wkfStatusId = (BigDecimal)row[1];
                String errorText = (String)row[2];
                BigDecimal addressId = (BigDecimal)row[3];
                String country_code = (String)row[4];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing Workflow Case # " + (i + 1) + " with id = " + wkfCaseId));
                }
                try {
                    Integer updateCount;
                    AbstractDAOAction callback;
                    HashMap<String, BigDecimal> contextData;
                    if (country_code == null) {
                        contextData = new HashMap<String, BigDecimal>();
                        contextData.put(PARAM_COUNTRY_CODE, addressId);
                        callback = new AbstractDAOAction(contextData){

                            public Object execute(Session session) {
                                Query query = session.getNamedQuery(UpdateEmptyCountryCodeProcess.UPDATE_COUNTRY_CODE);
                                query.setParameter(UpdateEmptyCountryCodeProcess.PARAM_COUNTRY_CODE, (Object)((BigDecimal)this.getContextData().get(UpdateEmptyCountryCodeProcess.PARAM_COUNTRY_CODE)));
                                return new Integer(query.executeUpdate());
                            }
                        };
                        updateCount = (Integer)this.getDao().execute(callback);
                        if (updateCount < 1 && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)(this.getProcessName() + ": Country code cannot be updated for " + addressId));
                        }
                    }
                    contextData = new HashMap();
                    contextData.put(PARAM_CASEID, wkfCaseId);
                    callback = new AbstractDAOAction(contextData){

                        public Object execute(Session session) {
                            Query query = session.getNamedQuery(UpdateEmptyCountryCodeProcess.CLOSE_WORKCASE);
                            query.setParameter(UpdateEmptyCountryCodeProcess.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(UpdateEmptyCountryCodeProcess.PARAM_CASEID)));
                            return new Integer(query.executeUpdate());
                        }
                    };
                    updateCount = (Integer)this.getDao().execute(callback);
                    if (updateCount < 1 && this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)(this.getProcessName() + ": Workflow case status not updated to Closed for caseId=" + wkfCaseId));
                    }
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing Update Empty Country Code batch process for Workflow Case " + wkfCaseId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block13;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Update Empty Country Code: Processing of current batch complete.");
            this.logger.debug((Object)("Update Empty Country Code: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("Update Empty Country Code: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }
}

