/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.batchprocess.SSNVerificationResponseProcessSpawnedThreadTask;
import gov.va.med.esr.common.batchprocess.SSNVerificationResponseProcessrProcessCompletedHandler;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.util.ThreadPool;
import java.util.List;

public class SSNVerificationResponseProcess
extends AbstractDataFileSingleRowIncrementProcess {
    LookupService lookupService;
    DemographicService demographicService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 100;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    public static final String SSN_VER_RES_PROC_THREAD_NAME = "SSNVERRESPROCTHREAD";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 100;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (acquiredData.isEmpty()) {
            return;
        }
        String rawData = context.getCurrentRowRawData();
        try {
            Object obj = acquiredData.get(0);
            if (this.processDataRecord(context, obj)) {
                if (this.isKeepProcessedData()) {
                    context.getProcessedData().add(obj);
                }
            } else {
                context.getExceptionData().add(this.createExceptionObject(rawData));
            }
        }
        catch (RuntimeException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Error processing data record: " + rawData), (Throwable)e);
            }
            context.getProcessStatistics().incrementNumberOfErrorRecords();
            context.getExceptionData().add(this.createExceptionObject(rawData));
        }
    }

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        boolean success = false;
        SSASSNVerificationData dataRecord = (SSASSNVerificationData)((Object)bean);
        this.spawnThread(context, dataRecord);
        success = true;
        return success;
    }

    private void spawnThread(DataFileProcessExecutionContext context, SSASSNVerificationData dataRecord) {
        try {
            while (SSNVerificationResponseProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                if (!this.shouldWriteExceptionData((DataProcessExecutionContext)context)) continue;
                ((SSNVerificationResponseProcessrProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
            if (this.shouldUpdateJobResult(context)) {
                this.updateJobResult((DataProcessExecutionContext)context);
            }
            if (this.shouldWriteExceptionData((DataProcessExecutionContext)context)) {
                ((SSNVerificationResponseProcessrProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData((DataProcessExecutionContext)context);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            SSNVerificationResponseProcessSpawnedThreadTask task = (SSNVerificationResponseProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAuditInfo(this.getAuditInfo());
            task.setDataRecord(dataRecord);
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("SSNVerificationResponseProcessSpawnedThreadTask was interrupted while it was spawning a thread. ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block11: {
            try {
                if (SSNVerificationResponseProcess.getTaskCount(context) == 0) break block11;
                SSNVerificationResponseProcess sSNVerificationResponseProcess = this;
                synchronized (sSNVerificationResponseProcess) {
                    boolean stillProcessing = true;
                    while (stillProcessing) {
                        ((Object)((Object)this)).wait();
                        if (SSNVerificationResponseProcess.getTaskCount(context) != 0) continue;
                        stillProcessing = false;
                    }
                }
            }
            catch (InterruptedException e) {
                this.throwIllegalStateException("HECLegacyDataSynchronizationConsumerProcess was interrupted while it was waiting for its spawned threads to complete", e);
            }
            finally {
                this.getThreadPool(context).stop();
                this.cleanThreadPool(context);
            }
        }
        if (this.shouldUpdateJobResult(context)) {
            this.updateJobResult(context);
        }
        if (this.shouldWriteExceptionData(context)) {
            ((SSNVerificationResponseProcessrProcessCompletedHandler)this.getDataProcessCompletedHandler()).appendExceptionData(context);
        }
        super.handleDataProcessCompleted(context);
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"SSNVerificationResponseProcessSpawnedThreadTask cleaned up the thread pool");
        }
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("SSNVerificationResponseProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataFileProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        SSNVerificationResponseProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(SSNVerificationResponseProcess.getTaskCount(context) + adjustment));
        }
    }

    private boolean shouldWriteExceptionData(DataProcessExecutionContext context) {
        int exceptionDataSize;
        int n = exceptionDataSize = context.getExceptionData() == null ? 0 : context.getExceptionData().size();
        return exceptionDataSize != 0 ? exceptionDataSize % 20 == 0 : false;
    }
}

