/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.GenerateQRYZ11Process;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.math.BigDecimal;
import java.util.HashMap;
import org.hibernate.Query;
import org.hibernate.Session;

public class ResendQRYZ11ForVBAErrorProcess
extends GenerateQRYZ11Process {
    private static final String UPDATE_ELIG_STATUS = "resendQRYZ11ForVBAError.updateEligibilityVerStatus";
    private static final String CLOSE_WORKCASE = "resendQRYZ11ForVBAError.closeWorkcase";
    private static final String PARAM_PERSONID = "personId";
    private static final String PARAM_CASEID = "caseId";

    @Override
    protected void processRecord(PersonEntityKey key, Object[] dataRow) throws Exception {
        Integer updateCount;
        AbstractDAOAction callback;
        HashMap<String, BigDecimal> contextData;
        String VPID2 = (String)dataRow[1];
        String eligStatusCode = (String)dataRow[2];
        BigDecimal workCaseId = (BigDecimal)dataRow[3];
        if (EligibilityStatus.CODE_VERIFIED.getCode().equals(eligStatusCode)) {
            contextData = new HashMap<String, BigDecimal>();
            contextData.put(PARAM_PERSONID, new BigDecimal(key.getKeyValueAsString()));
            callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(ResendQRYZ11ForVBAErrorProcess.UPDATE_ELIG_STATUS);
                    query.setParameter(ResendQRYZ11ForVBAErrorProcess.PARAM_PERSONID, (Object)((BigDecimal)this.getContextData().get(ResendQRYZ11ForVBAErrorProcess.PARAM_PERSONID)));
                    return new Integer(query.executeUpdate());
                }
            };
            updateCount = (Integer)this.getDao().execute(callback);
            if (updateCount < 1 && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(this.getProcessName() + ": EligibilityVerification not updated for personId=" + key.getKeyValueAsString()));
            }
        } else {
            this.getMessagingService().generateMessage(key, VPID2);
        }
        contextData = new HashMap();
        contextData.put(PARAM_CASEID, workCaseId);
        callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query query = session.getNamedQuery(ResendQRYZ11ForVBAErrorProcess.CLOSE_WORKCASE);
                query.setParameter(ResendQRYZ11ForVBAErrorProcess.PARAM_CASEID, (Object)((BigDecimal)this.getContextData().get(ResendQRYZ11ForVBAErrorProcess.PARAM_CASEID)));
                return new Integer(query.executeUpdate());
            }
        };
        updateCount = (Integer)this.getDao().execute(callback);
        if (updateCount < 1 && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(this.getProcessName() + ": Workflow case status not updated to Closed for caseId=" + workCaseId));
        }
    }
}

