/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.RequestSSNVerificationProcessSpawnedThreadTask;
import gov.va.med.esr.common.batchprocess.RequestSSNVerificationStatistics;
import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.batchprocess.SSNVerificationProcessExecutionContext;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.SSNVerification;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;
import gov.va.med.esr.common.persistent.person.SSNVerificationDetailDAO;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UniqueIdentifierGenerator;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.ThreadPool;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.StringUtils;

public class RequestSSNVerificationProcess
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 100;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 100;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;
    private static String PARAMETER_HOLDER = "PARAMETER_HOLDER";
    private static SSAVerificationStatus SSN_VERIFICATION_IN_PROCESS = null;
    private static int MAX_RECORD_PER_FILE = 250000;
    private String updateQueryString;
    private LookupService lookupService;
    private DemographicService demographicService;
    private FormattedFileWriter outputFileWriter;
    private UniqueIdentifierGenerator generator;
    private SSNVerificationDetailDAO ssnVerificationDetailDAO;

    public void setMasRecordPerFile(int max) {
        MAX_RECORD_PER_FILE = max;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public SSNVerificationDetailDAO getSsnVerificationDetailDAO() {
        return this.ssnVerificationDetailDAO;
    }

    public void setSsnVerificationDetailDAO(SSNVerificationDetailDAO ssnVerificationDetailDAO) {
        this.ssnVerificationDetailDAO = ssnVerificationDetailDAO;
    }

    public FormattedFileWriter getOutputFileWriter() {
        return this.outputFileWriter;
    }

    public void setOutputFileWriter(FormattedFileWriter outputFileWriter) {
        this.outputFileWriter = outputFileWriter;
    }

    public UniqueIdentifierGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(UniqueIdentifierGenerator generator) {
        this.generator = generator;
    }

    public String getUpdateQueryString() {
        return this.updateQueryString;
    }

    private String generateControlIdentifier() throws ServiceException {
        return this.generator.generate().toString();
    }

    public void setUpdateQueryString(String updateQueryString) {
        this.updateQueryString = updateQueryString;
    }

    protected DataProcessExecutionContext createDataProcessExecutionContext() {
        SSNVerificationProcessExecutionContext context = new SSNVerificationProcessExecutionContext();
        context.setProcessStatistics(this.createProcessStatistics());
        return context;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new RequestSSNVerificationStatistics();
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    private boolean isThreaded() {
        return gov.va.med.fw.util.StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block16: {
            if (this.isThreaded()) {
                try {
                    if (RequestSSNVerificationProcess.getTaskCount(context) == 0) break block16;
                    RequestSSNVerificationProcess requestSSNVerificationProcess = this;
                    synchronized (requestSSNVerificationProcess) {
                        boolean stillProcessing = true;
                        while (stillProcessing) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)(new Date() + " RequestSSNVerificationProcess.handleDataProcessCompleted() : taskCount before wait: " + RequestSSNVerificationProcess.getTaskCount(context)));
                            }
                            ((Object)((Object)this)).wait();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)(new Date() + " RequestSSNVerificationProcess.handleDataProcessCompleted() : taskCount after wait: " + RequestSSNVerificationProcess.getTaskCount(context)));
                            }
                            if (RequestSSNVerificationProcess.getTaskCount(context) != 0) continue;
                            stillProcessing = false;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.throwIllegalStateException("RequestSSNVerificationProcess was interrupted while it was waiting for its spawned threads to complete", e);
                }
                finally {
                    this.getThreadPool(context).stop();
                    this.cleanThreadPool(context);
                }
            }
        }
        List vetFileOutputData = ((SSNVerificationProcessExecutionContext)context).getVetFileOutputData();
        RequestSSNVerificationStatistics stats = (RequestSSNVerificationStatistics)context.getProcessStatistics();
        if (vetFileOutputData != null && vetFileOutputData.size() > 0) {
            RequestSSNVerificationProcess requestSSNVerificationProcess = this;
            synchronized (requestSSNVerificationProcess) {
                this.outputFileWriter.appendData(vetFileOutputData);
            }
            stats.setNumberOfSuccessfulRecords(stats.getNumberOfSuccessfulRecords() + vetFileOutputData.size());
            stats.setNumberOfSuccessfulVetRecords(stats.getNumberOfSuccessfulVetRecords() + vetFileOutputData.size());
        }
        stats.setVetProcessingEndDate(new Date());
        this.updateJobResult(context);
        super.handleDataProcessCompleted(context);
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("RequestSSNVerificationProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataQueryProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        RequestSSNVerificationProcess.adjustTaskCount(context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataQueryProcessExecutionContext context, int adjustment) {
        DataQueryProcessExecutionContext dataQueryProcessExecutionContext = context;
        synchronized (dataQueryProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(RequestSSNVerificationProcess.getTaskCount((DataProcessExecutionContext)context) + adjustment));
        }
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        SSNVerificationProcessExecutionContext ssnContext = (SSNVerificationProcessExecutionContext)context;
        if (ssnContext.isReachMaxSize()) {
            return null;
        }
        Object arg = ssnContext.getExecutionArguments();
        boolean onlySpouseAndDependentOption = false;
        if (arg != null && arg instanceof String && arg.toString().equals("-sd")) {
            onlySpouseAndDependentOption = true;
        }
        RequestSSNVerificationStatistics stats = (RequestSSNVerificationStatistics)context.getProcessStatistics();
        List list = null;
        if (!onlySpouseAndDependentOption && !ssnContext.isVeteranDataAcquired()) {
            list = this.ssnVerificationDetailDAO.getSSNVerificationListToProcess();
            int size = list == null ? 0 : list.size();
            if (size > MAX_RECORD_PER_FILE) {
                size = MAX_RECORD_PER_FILE;
                list = list.subList(0, MAX_RECORD_PER_FILE - 1);
                ssnContext.setReachMaxSize(true);
            }
            stats.setNumberOfTotalVetRecords(size);
            stats.setNumberOfTotalRecords(stats.getNumberOfTotalRecords() + size);
            ssnContext.setVeteranDataAcquired(true);
            ssnContext.setHasNoSpouseDependents(true);
        } else {
            if (onlySpouseAndDependentOption) {
                ssnContext.setVeteranDataProcessed(true);
            }
            ssnContext.setHasNoSpouseDependents(false);
            Object[] params = new Object[]{Integer.valueOf(SSAVerificationStatus.NEW_RECORD.getCode()), Integer.valueOf(SSAVerificationStatus.RESEND_TO_SSA.getCode()), SSNType.CODE_ACTIVE.getCode()};
            context.getCurrentDataQuery().getQuery().setParamValues(params);
            list = super.doAcquireData(context);
        }
        return list;
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        block9: {
            try {
                if (acquiredData != null) {
                    if (SSN_VERIFICATION_IN_PROCESS == null) {
                        SSN_VERIFICATION_IN_PROCESS = this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.IN_PROCESS.getCode());
                    }
                    SSNVerificationProcessExecutionContext ssnContext = (SSNVerificationProcessExecutionContext)context;
                    SSNVerification ssnVerification = this.getSSNVerification(ssnContext);
                    if (!ssnContext.isVeteranDataProcessed()) {
                        ssnVerification = this.processVeterans(ssnContext, ssnVerification, acquiredData);
                        ssnContext.setVeteranDataProcessed(true);
                    }
                    if (ssnContext.isInterrupted()) {
                        return;
                    }
                    if (!ssnContext.hasNoSpouseDependents()) {
                        int size = acquiredData == null ? 0 : acquiredData.size();
                        if (ssnContext.getProcessStatistics().getNumberOfTotalRecords() + size > MAX_RECORD_PER_FILE) {
                            acquiredData = acquiredData.subList(0, MAX_RECORD_PER_FILE - ssnContext.getProcessStatistics().getNumberOfTotalRecords() - 1);
                            ssnContext.getProcessStatistics().setNumberOfTotalRecords(MAX_RECORD_PER_FILE);
                            ssnContext.setReachMaxSize(true);
                        } else {
                            ssnContext.getProcessStatistics().setNumberOfTotalRecords(ssnContext.getProcessStatistics().getNumberOfTotalRecords() + size);
                        }
                        List spouseAndDependentsData = this.convertToOutputData(acquiredData);
                        ssnVerification = this.processSpouseAndDependents(ssnContext, ssnVerification, spouseAndDependentsData);
                    }
                }
            }
            catch (Exception e) {
                context.getProcessStatistics().setNumberOfErrorRecords(context.getProcessStatistics().getNumberOfErrorRecords() + acquiredData.size());
                String errorMessage = "Error while executing Request SSN Verification batch process : Reason: " + e.getMessage();
                context.getExceptionData().add(errorMessage);
                if (!this.logger.isWarnEnabled()) break block9;
                this.logger.warn((Object)errorMessage, (Throwable)e);
            }
        }
    }

    private SSNVerification getSSNVerification(SSNVerificationProcessExecutionContext ssnContext) throws DAOException {
        if (ssnContext.getSsnVerification() != null) {
            return ssnContext.getSsnVerification();
        }
        SSNVerification ssnVerification = new SSNVerification();
        ssnVerification.setCountSentToSsa(new Integer(0));
        this.getDao().saveObject((Object)ssnVerification);
        ssnContext.setSsnVerification(ssnVerification);
        return ssnVerification;
    }

    private SSNVerification processSpouseAndDependents(SSNVerificationProcessExecutionContext context, SSNVerification ssnVerification, List spouseAndDependentsData) {
        block5: {
            RequestSSNVerificationStatistics stats = (RequestSSNVerificationStatistics)context.getProcessStatistics();
            try {
                String updatedQueryString = null;
                Object[] spouseAndDependentsSSNIds = null;
                if (spouseAndDependentsData != null && !spouseAndDependentsData.isEmpty()) {
                    String parameterHolder = this.createCommaSeparatedParameterHolders(spouseAndDependentsData);
                    updatedQueryString = StringUtils.replace((String)this.getUpdateQueryString(), (String)PARAMETER_HOLDER, (String)parameterHolder);
                    spouseAndDependentsSSNIds = this.getParameterData(spouseAndDependentsData, SSN_VERIFICATION_IN_PROCESS);
                    List newVerificationDetails = this.createSummaryStatisticsData(ssnVerification, spouseAndDependentsData);
                    ssnVerification = this.demographicService.updateRequestSSNVerificationData(ssnVerification, newVerificationDetails, updatedQueryString, spouseAndDependentsSSNIds);
                }
                if (context.getSsnVerification() == null) {
                    context.setSsnVerification(ssnVerification);
                }
                if (spouseAndDependentsData != null && !spouseAndDependentsData.isEmpty()) {
                    this.outputFileWriter.appendData(spouseAndDependentsData);
                }
                context.getProcessStatistics().setNumberOfSuccessfulRecords(context.getProcessStatistics().getNumberOfSuccessfulRecords() + spouseAndDependentsData.size());
                stats.setNumberOfSuccessfulSDRecords(stats.getNumberOfSuccessfulSDRecords() + spouseAndDependentsData.size());
            }
            catch (Exception e) {
                context.getProcessStatistics().setNumberOfErrorRecords(context.getProcessStatistics().getNumberOfErrorRecords() + (spouseAndDependentsData == null ? 0 : spouseAndDependentsData.size()));
                stats.setNumberOfErrorSDRecords(stats.getNumberOfErrorSDRecords() + (spouseAndDependentsData == null ? 0 : spouseAndDependentsData.size()));
                String errorMessage = "Error while executing Request SSN Verification batch process for spouse and dependents : Reason: " + e.getMessage();
                context.getExceptionData().add(errorMessage);
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn((Object)errorMessage, (Throwable)e);
            }
        }
        return ssnVerification;
    }

    private String createCommaSeparatedParameterHolders(List spouseAndDependentsData) {
        StringBuffer parameterHolder = new StringBuffer();
        for (int i = 0; i < spouseAndDependentsData.size(); ++i) {
            parameterHolder.append("?");
            if (i == spouseAndDependentsData.size() - 1) continue;
            parameterHolder.append(",");
        }
        return parameterHolder.toString();
    }

    private Object[] getParameterData(List spouseAndDependentsData, SSAVerificationStatus status) {
        Object[] parameterData = new Object[spouseAndDependentsData.size() + 1];
        parameterData[0] = status;
        int i = 1;
        for (SSASSNVerificationData data : spouseAndDependentsData) {
            parameterData[i] = new BigDecimal(data.getSsnId());
            ++i;
        }
        return parameterData;
    }

    private SSNVerification processVeterans(SSNVerificationProcessExecutionContext context, SSNVerification ssnVerification, List acquiredData) {
        RequestSSNVerificationStatistics stats = (RequestSSNVerificationStatistics)context.getProcessStatistics();
        if (acquiredData == null || acquiredData.isEmpty()) {
            return ssnVerification;
        }
        stats.setVetProcessingStartDate(new Date());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" RequestSSNVerificationProcess.processVeterans() : Total number of Veterans Received: " + acquiredData.size()));
        }
        this.updateJobResult((DataProcessExecutionContext)context);
        ArrayList vetFileOutputData = new ArrayList();
        SSNVerificationDetail detail = null;
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            detail = (SSNVerificationDetail)((Object)acquiredData.get(i));
            detail.setSsnVerification(ssnVerification);
            Object[] data = new Object[]{detail, stats, vetFileOutputData};
            this.spawnThread(context, data);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(" RequestSSNVerificationProcess.processVeterans() i= " + i));
        }
        context.setVetFileOutputData(vetFileOutputData);
        return ssnVerification;
    }

    private List convertToOutputData(List veteranAndSpouseData) {
        ArrayList<SSASSNVerificationData> ssnVerificationDataList = new ArrayList<SSASSNVerificationData>();
        SSASSNVerificationData ssnVerificationData = null;
        if (veteranAndSpouseData != null) {
            for (Object[] dataRow : veteranAndSpouseData) {
                try {
                    ssnVerificationData = new SSASSNVerificationData();
                    ssnVerificationData.setSsnId((String)dataRow[0]);
                    ssnVerificationData.setSsn((String)dataRow[1]);
                    String relationshipType = (String)dataRow[2];
                    if (Relationship.CODE_SPOUSE.getCode().equals(relationshipType)) {
                        ssnVerificationData.setSpouseCode("1");
                    }
                    ssnVerificationData.setLastName((String)dataRow[3]);
                    ssnVerificationData.setFirstName((String)dataRow[4]);
                    ssnVerificationData.setMiddleInitial((String)dataRow[5]);
                    ssnVerificationData.setDateOfBirth((ImpreciseDate)dataRow[6]);
                    ssnVerificationData.setGender((String)dataRow[7]);
                    ssnVerificationData.setHECInternalID(this.generateControlIdentifier());
                    ssnVerificationData.setSsaVerificationStatus(this.lookupService.getSSAVerificationStatusByCode(SSAVerificationStatus.IN_PROCESS.getCode()));
                }
                catch (ServiceException e) {
                    this.logger.error((Object)"Error while converting to output data for veteran and spouse data", (Throwable)e);
                }
                ssnVerificationDataList.add(ssnVerificationData);
            }
        }
        return ssnVerificationDataList;
    }

    private List createSummaryStatisticsData(SSNVerification ssnVerification, List outputFileData) {
        ssnVerification.setCountSentToSsa(new Integer(ssnVerification.getCountSentToSsa() + outputFileData.size()));
        ssnVerification.setSsaSentDate(Calendar.getInstance().getTime());
        ArrayList<SSNVerificationDetail> newVerificationDetails = new ArrayList<SSNVerificationDetail>();
        SSNVerificationDetail ssnVerificationDetail = null;
        Iterator iter = outputFileData.iterator();
        while (iter.hasNext()) {
            try {
                SSASSNVerificationData ssaSSNVerificationData = (SSASSNVerificationData)((Object)iter.next());
                ssnVerificationDetail = new SSNVerificationDetail();
                ssnVerificationDetail.setHECInternalId(ssaSSNVerificationData.getHECInternalID());
                if (ssaSSNVerificationData.getSsnId() == null) {
                    ssnVerificationDetail.setPersonId(new BigDecimal(ssaSSNVerificationData.getPersonId()));
                } else {
                    ssnVerificationDetail.setSsnId(new BigDecimal(ssaSSNVerificationData.getSsnId()));
                }
                ssnVerificationDetail.setSsnText(ssaSSNVerificationData.getSsn());
                ssnVerificationDetail.setSsnVerification(ssnVerification);
                newVerificationDetails.add(ssnVerificationDetail);
            }
            catch (Exception e) {
                this.logger.error((Object)"createSummaryStatisticsData Exception:", (Throwable)e);
            }
        }
        return newVerificationDetails;
    }

    private void spawnThread(SSNVerificationProcessExecutionContext context, Object[] data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" RequestSSNVerification.spawnThread() taskCount = " + RequestSSNVerificationProcess.getTaskCount((DataProcessExecutionContext)context)));
        }
        try {
            while (RequestSSNVerificationProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            RequestSSNVerificationProcessSpawnedThreadTask task = (RequestSSNVerificationProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAuditInfo(this.getAuditInfo());
            task.setProcessName(this.getProcessName());
            task.setAcquiredData(data);
            task.setSSNVerificationStatus(SSN_VERIFICATION_IN_PROCESS);
            task.setGenerator(this.generator);
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("SSNVerificationProcessSpawnedThreadTask was interrupted while it was spawning a thread. ", e);
        }
    }
}

