/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.financials.RelaxationPercentageDAO;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.ScrollableCallback;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.Validate;

public class RelaxationPercentageRetroactiveProcess
extends AbstractDataQueryIncrementalProcess {
    private EligibilityEnrollmentService eligibilityEnrollmentService;
    private RelaxationPercentageDAO relaxationPercentageDAO;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("RelaxationPercentageRetroactiveProcess batch process: processing " + (acquiredData == null ? 0 : acquiredData.size()) + " rows from source query"));
        }
        if (acquiredData == null) {
            return;
        }
        ProcessStatistics stats = context.getProcessStatistics();
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            Object[] row = (Object[])acquiredData.get(i);
            BigDecimal personId = (BigDecimal)row[0];
            if (this.logger.isDebugEnabled()) {
                this.logger.error((Object)("Processing person ID  " + personId));
            }
            try {
                this.eligibilityEnrollmentService.processCalculateEEForCleanup(new PersonIdEntityKeyImpl(personId), true, true);
                stats.incrementNumberOfSuccessfulRecords();
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error during RelaxationPercentageRetroactiveProcess for person ID " + personId), (Throwable)e);
                }
                stats.incrementNumberOfErrorRecords();
            }
            if (!stats.isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"RelaxationPercentageRetroactiveProcess: Processing of current batch complete.");
            this.logger.debug((Object)("RelaxationPercentageRetroactiveProcess: Successful records count = " + stats.getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("RelaxationPercentageRetroactiveProcess: Failure records count =" + stats.getNumberOfErrorRecords()));
        }
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        QueryInfo query = context.getCurrentDataQuery().getQuery();
        query.setFetchSize(this.getFetchSize());
        String executionArgument = (String)context.getExecutionArguments();
        if (executionArgument == null) {
            throw new Exception("Required execution argument \"incomeYear\" was not set. Value should be a single four-digit Integer representing the income year for which we are retroactively processing people.");
        }
        Integer incomeYear = new Integer(executionArgument);
        query.setParamNames(new String[]{"incomeYear"});
        query.setParamValues(new Object[]{incomeYear});
        this.getDao().scroll((ScrollableCallback)this, query, (QueryIncrementTracker)context);
        return null;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.eligibilityEnrollmentService);
        Validate.notNull((Object)this.relaxationPercentageDAO);
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public void setRelaxationPercentageDAO(RelaxationPercentageDAO relaxationPercentageDAO) {
        this.relaxationPercentageDAO = relaxationPercentageDAO;
    }
}

