/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.UnmigratedICNFileData;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import org.apache.commons.lang.Validate;

public class ReceiveUnmigratedICNFileProcess
extends AbstractDataFileSingleRowIncrementProcess {
    protected MessagingService messagingService;
    protected PSDelegateService psDelegateService;
    protected PersonService personService;

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        UnmigratedICNFileData dataRecord = (UnmigratedICNFileData)((Object)bean);
        boolean success = true;
        Person person = null;
        try {
            person = this.matchPerson(dataRecord);
            if (person != null) {
                Integer incomeYear = dataRecord.getIncomeYear();
                if (incomeYear == null || incomeYear < 1992) {
                    incomeYear = new Integer(2007);
                }
                this.messagingService.triggerQRYZ07(person, dataRecord.getFacility(), incomeYear, false);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("QRYZ07 triggered for Person: " + person.getPersonEntityKey().getKeyValueAsString()));
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            PersonEntityKey key;
            PersonEntityKey personEntityKey = key = person != null ? person.getPersonEntityKey() : null;
            if (key != null) {
                this.throwIllegalStateException("Unable to trigger QRYZ07 for person: " + key.getKeyValueAsString(), e);
            }
            this.throwIllegalStateException("Unable to trigger QRYZ07 because can not find person for DFN: " + dataRecord.getDFN(), e);
        }
        return success;
    }

    private Person matchPerson(UnmigratedICNFileData data) throws ServiceException {
        PersonIdentityTraits traits = this.psDelegateService.getIdentityTraitsWithCompositeCall(data.getDFN(), data.getFacility().getCode());
        return this.personService.find(traits);
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.messagingService, (String)"messagingService is required");
        Validate.notNull((Object)this.personService, (String)"personService is required");
        Validate.notNull((Object)this.psDelegateService, (String)"psDelegateService is required");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }
}

