/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.ReProcessVeteransIn8eAnd8gProcess;
import gov.va.med.esr.common.batchprocess.UnexpectedEnrollmentException;
import gov.va.med.esr.common.batchprocess.UnexpectedEnrollmentStatusException;
import gov.va.med.esr.common.batchprocess.VeteranUpdaterProcess;
import gov.va.med.esr.common.rule.parameter.MTTotalIncomePresentAndFinancialStmtIncomeNullException;
import gov.va.med.esr.common.util.FeedbackTask;
import gov.va.med.esr.common.util.TimerFactory;
import gov.va.med.esr.service.PersonLockedException;
import gov.va.med.fw.persistent.DAOOperations;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Timer;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class ReProcessVeteransIn8eAnd8gProcessImpl
implements ReProcessVeteransIn8eAnd8gProcess,
BeanFactoryAware {
    public final String FIND_VETERANS_FOR_CONVERSION_SQL = "select p.person_id, p.vpid_value from Person p JOIN Enrollment_Determination ed ON ED.PERSON_ID = P.PERSON_ID AND ED.ENROLLMENT_DETERMINATION_ID =(SELECT MAX(ENROLLMENT_DETERMINATION_ID) FROM Enrollment_Determination ed2 WHERE ed2.PERSON_ID = p.PERSON_ID) JOIN STD_ENROLLMENTPRIORGRP pg ON PG.ID=ED.PRIORITY_GROUP_TYPE_ID AND PG.CODE=8 JOIN STD_ENROLLMENTPRIORSGRP egs ON EGS.ID=ED.PRIORITY_SUB_GROUP_TYPE_ID AND (EGS.CODE=5 OR EGS.CODE=7) JOIN Income_Test it ON IT.PERSON_ID=P.PERSON_ID AND IT.INCOME_YEAR=2008 AND IT.PRIMARY_TEST_IND='1' AND IT.DISCLOSE_FINANCIAL_INCOME_IND=1 AND IT.AGREED_TO_PAY_DEDUCTIBLE_IND=1";
    public final String PERSON_INCLUSION_SQL = "AND P.PERSON_ID IN (?)";
    private int delay = 30000;
    private String personInclusionList;
    private BeanFactory beanFactory;
    private Log logStatus;
    private HttpServletResponse httpServletResponse;
    private JspWriter jspWriter;
    private TimerFactory timerFactory;
    private VeteranUpdaterProcess veteranUpdaterProcess;

    public void setVeteranUpdaterProcess(VeteranUpdaterProcess veteranUpdaterProcess) {
        this.veteranUpdaterProcess = veteranUpdaterProcess;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public void setPersonInclusionList(String personInclusionList) {
        this.personInclusionList = personInclusionList;
    }

    public void setTimerFactory(TimerFactory timerFactory) {
        this.timerFactory = timerFactory;
    }

    public void setLogStatus(Log logStatus) {
        this.logStatus = logStatus;
    }

    @Override
    public void setResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public void setJspWriter(JspWriter jspWriter) {
        this.jspWriter = jspWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.logStatus.info((Object)"Start");
        Timer timer = null;
        try {
            DAOOperations genericDAO = (DAOOperations)this.beanFactory.getBean("genericDAO");
            String queryString = "select p.person_id, p.vpid_value from Person p JOIN Enrollment_Determination ed ON ED.PERSON_ID = P.PERSON_ID AND ED.ENROLLMENT_DETERMINATION_ID =(SELECT MAX(ENROLLMENT_DETERMINATION_ID) FROM Enrollment_Determination ed2 WHERE ed2.PERSON_ID = p.PERSON_ID) JOIN STD_ENROLLMENTPRIORGRP pg ON PG.ID=ED.PRIORITY_GROUP_TYPE_ID AND PG.CODE=8 JOIN STD_ENROLLMENTPRIORSGRP egs ON EGS.ID=ED.PRIORITY_SUB_GROUP_TYPE_ID AND (EGS.CODE=5 OR EGS.CODE=7) JOIN Income_Test it ON IT.PERSON_ID=P.PERSON_ID AND IT.INCOME_YEAR=2008 AND IT.PRIMARY_TEST_IND='1' AND IT.DISCLOSE_FINANCIAL_INCOME_IND=1 AND IT.AGREED_TO_PAY_DEDUCTIBLE_IND=1";
            if (this.personInclusionList != null) {
                queryString = queryString + "AND P.PERSON_ID IN (?)";
                queryString = queryString.replaceAll("\\?", this.personInclusionList);
            }
            this.jspWriter.println("<br/><br/>Finding veterans");
            this.httpServletResponse.flushBuffer();
            FeedbackTask feedbackTask = new FeedbackTask(this.jspWriter, this.httpServletResponse, ".");
            timer = this.timerFactory.scheduleTimerTask(feedbackTask, 0L, this.delay);
            List results = genericDAO.executeSQLQuery(queryString);
            timer.cancel();
            String numberOfVeteransMessage = "Found " + results.size() + " veteran(s).";
            this.jspWriter.println("<br/>" + numberOfVeteransMessage);
            this.logStatus.info((Object)numberOfVeteransMessage);
            this.httpServletResponse.flushBuffer();
            for (int i = 0; i < results.size(); ++i) {
                BigDecimal personId = (BigDecimal)((Object[])results.get(i))[0];
                personId.setScale(0, 4);
                String vpid = (String)((Object[])results.get(i))[1];
                try {
                    this.veteranUpdaterProcess.updateVeteran(personId.toString(), vpid, i);
                    continue;
                }
                catch (Exception e) {
                    Throwable t;
                    if (e instanceof PersonLockedException) {
                        String veteranLockedMessage = "Veteran with person id: " + personId + " and vpid: " + vpid + ".  Veteran is locked and cannot be updated.";
                        this.logStatus.error((Object)veteranLockedMessage);
                        this.jspWriter.println("<br/>" + veteranLockedMessage);
                        this.httpServletResponse.flushBuffer();
                        continue;
                    }
                    if (e instanceof UnexpectedEnrollmentException) {
                        String unexpectedEnrollmentGroupMessage = "Veteran with person id: " + personId + " and vpid: " + vpid + ".  Veteran not enrolled in 8b or 8d after conversion.";
                        this.logStatus.error((Object)unexpectedEnrollmentGroupMessage);
                        this.jspWriter.println("<br/>" + unexpectedEnrollmentGroupMessage);
                        this.httpServletResponse.flushBuffer();
                        continue;
                    }
                    if (e instanceof UnexpectedEnrollmentStatusException) {
                        String unexpectedEnrollStatusMessage = "Veteran with person id: " + personId + " and vpid: " + vpid + " . Veteran status not verifed after conversion.";
                        this.logStatus.error((Object)unexpectedEnrollStatusMessage);
                        this.jspWriter.println("<br/>" + unexpectedEnrollStatusMessage);
                        this.httpServletResponse.flushBuffer();
                        continue;
                    }
                    for (t = e.getCause(); t != null && t.getCause() != null; t = t.getCause()) {
                    }
                    if (t instanceof MTTotalIncomePresentAndFinancialStmtIncomeNullException) {
                        StringBuffer veteranFinStmtIncomeNullMsg = new StringBuffer("Veteran with person id: " + personId + " and vpid: " + vpid + ".  " + t.getMessage());
                        this.logStatus.error((Object)veteranFinStmtIncomeNullMsg);
                        this.jspWriter.println("<br/>" + veteranFinStmtIncomeNullMsg);
                        this.httpServletResponse.flushBuffer();
                        continue;
                    }
                    StringBuffer unexpectedErrorMsg = new StringBuffer("Veteran with person id: " + personId + " and vpid: " + vpid + ". Unexpected error during veteran conversion: " + e.getMessage());
                    this.logStatus.error((Object)unexpectedErrorMsg, (Throwable)e);
                    this.jspWriter.println("<br/>" + unexpectedErrorMsg);
                    this.httpServletResponse.flushBuffer();
                }
            }
        }
        catch (Exception e) {
            this.logStatus.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                this.jspWriter.println("<br/>Complete");
                this.httpServletResponse.flushBuffer();
            }
            catch (IOException iOException) {}
            if (timer != null) {
                timer.cancel();
            }
            this.logStatus.info((Object)"Complete");
        }
    }

    @Override
    public void setDelay(int delay) {
        this.delay = delay;
    }
}

