/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.batchprocess.LoadRegistryFileData;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PrisonerOfWarRegistryFileData
extends LoadRegistryFileData {
    private static final long serialVersionUID = -4989353564824931925L;
    private static Class[] AUTO_REGISTER_CLASSES = new Class[]{PrisonerOfWar.class, POWEpisode.class};
    private static final String DOCUMENT_TYPE = "documentType";
    private static final String POW_INDICATOR = "powIndicator";
    private static final String MILITARY_SERVICE_NUMBER = "militaryServiceNumber";
    private static final String NUMBER_OF_DAYS_IN_CAPTIVITY = "numberOfDaysInCaptivity";
    private static final String DATE_ENTERED = "dateEntered";
    private static final String DATA_SOURCE = "dataSource";
    private static final String CAMP_LOCATION = "campLocation";
    private static final String CONFINEMENT_LOCATION = "confinementLocation";
    private static final String RELEASE_DATE = "releaseDate";
    private static final String CAPTURE_DATE = "captureDate";
    private static final String DEATH_DATE = "deathDate";

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        PrisonerOfWar prisonerOfWar = new PrisonerOfWar();
        POWEpisode episode = new POWEpisode();
        RegistryTrait trait = new RegistryTrait();
        RegistryTraitDetail traitDetail = new RegistryTraitDetail();
        int i = 0;
        trait.setLastName(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        trait.setFirstName(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        trait.setMiddleName(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        trait.setPrefix(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        trait.setSuffix(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        trait.setEducationalDegree(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        trait.setSsn(this.buildSsnValue(parsedRow.getString(i++)));
        prisonerOfWar.setIcn(StringUtils.stripToNull((String)parsedRow.getString(i++)));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)trait), (String)DEATH_DATE, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)CAPTURE_DATE, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)RELEASE_DATE, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)CONFINEMENT_LOCATION, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)CAMP_LOCATION, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)DATA_SOURCE, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)DATE_ENTERED, (String)parsedRow.getString(i++));
        episode.setNumberOfDaysInCaptivity(this.buildIntegerValue(parsedRow.getString(i++)));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)traitDetail), (String)MILITARY_SERVICE_NUMBER, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)prisonerOfWar), (String)POW_INDICATOR, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)episode), (String)DOCUMENT_TYPE, (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)trait), (String)"registryType", (String)RegistryType.CODE_POW_REGISTRY.getCode());
        trait.addRegistryTraitDetail(traitDetail);
        prisonerOfWar.setRegistryTrait(trait);
        prisonerOfWar.addEpisode(episode);
        this.setRegistry(prisonerOfWar);
    }

    public OrderedMap getRawFileData() throws Exception {
        return null;
    }

    public Class[] getClassesForAutoRegisterConverters() {
        return AUTO_REGISTER_CLASSES;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClasses((Class[])AUTO_REGISTER_CLASSES);
    }
}

