/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.AbstractOPPExtractOutputFileProducer;
import gov.va.med.esr.common.batchprocess.OPPExtractExecutionContext;
import gov.va.med.esr.common.batchprocess.OPPExtractProcessStatistics;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.util.StringUtils;
import java.util.List;

public class OPPExtractMainOutputFileProducer
extends AbstractOPPExtractOutputFileProducer {
    private static final String CODE_NO = "0";
    private static final String CODE_YES = "1";

    @Override
    protected RawFileDataList setIdentityTraitsOnOutputData(RawFileDataList rawFileDataRow, PersonIdentityTraits traits) {
        rawFileDataRow.set(1, (Object)(traits == null || traits.getSsn() == null ? "" : traits.getSsn().getSsnText()));
        BirthRecord birthRecord = traits.getBirthRecord();
        if (birthRecord != null && birthRecord.getBirthDate() != null) {
            String formattedDateOfBirth = this.getCenturyFormattedDate(birthRecord.getBirthDate().getDate());
            rawFileDataRow.set(4, (Object)(formattedDateOfBirth == null ? "" : formattedDateOfBirth));
        }
        rawFileDataRow.set(21, (Object)(traits == null || traits.getGender() == null ? "" : traits.getGender().getCode()));
        Name name = traits.getLegalName();
        if (name != null) {
            rawFileDataRow.set(33, (Object)(name.getGivenName() == null ? "" : name.getGivenName()));
            rawFileDataRow.set(34, (Object)(name.getMiddleName() == null ? "" : name.getMiddleName()));
            rawFileDataRow.set(35, (Object)(name.getFamilyName() == null ? "" : name.getFamilyName()));
            rawFileDataRow.set(36, (Object)(name.getSuffix() == null ? "" : name.getSuffix()));
            rawFileDataRow.set(37, (Object)(name.getPrefix() == null ? "" : name.getPrefix()));
        }
        return rawFileDataRow;
    }

    @Override
    protected void incrementStatistics(OPPExtractExecutionContext context, List outputFileData) {
        OPPExtractProcessStatistics statistics = (OPPExtractProcessStatistics)context.getProcessStatistics();
        this.setStatistics(statistics, outputFileData);
    }

    private void setStatistics(OPPExtractProcessStatistics statistics, List outputFileData) {
        statistics.incrementNumberOfSuccessfulRecords(outputFileData.size());
        statistics.incrementNumberOfMainFileRecords(outputFileData.size());
        for (RawFileDataList fileData : outputFileData) {
            if (this.isEnrolleeStatusCriteriaMatched(fileData)) {
                statistics.incrementNumberOfTotalEnrollees(1);
            }
            if (this.isDeceasedBeneficiariesCriteriaMatched(fileData)) {
                statistics.incrementNumberOfDeceasedBeneficiaries(1);
            }
            if (this.isCanceledDeclinedCriteriaMatched(fileData)) {
                statistics.incrementNumberOfCanceledDeclinedEnrollees(1);
            }
            if (this.isIneligibleCriteriaMatched(fileData)) {
                statistics.incrementNumberOfIneligibleEnrolees(1);
            }
            if (this.isPendingMeansTestCriteriaMatched(fileData)) {
                statistics.incrementNumberOfPendingMeansTestRecords(1);
            }
            if (this.isAutoEnrolledRecordsCriteriaMatched(fileData)) {
                statistics.incrementNumberOfAutoEnrolledRecords(1);
            }
            if (this.isOfficialEnrolleeCriteriaMatched(fileData)) {
                statistics.incrementNumberOfOfficialEnrollees(1);
            }
            if (this.isUnOfficialEnrolleeCriteriaMatched(fileData)) {
                statistics.incrementNumberOfUnOfficialEnrollees(1);
            }
            if (!this.isActiveHealthInsuranceCriteriaMatched(fileData)) continue;
            statistics.incrementNumberOfActiveHealthInsuranceRecords(1);
        }
    }

    private boolean isActiveHealthInsuranceCriteriaMatched(RawFileDataList fileData) {
        String activeHealthInsurance = (String)fileData.get(12);
        return StringUtils.isNotEmpty((String)activeHealthInsurance) && StringUtils.equals((String)activeHealthInsurance, (String)CODE_YES);
    }

    private boolean isUnOfficialEnrolleeCriteriaMatched(RawFileDataList fileData) {
        String officialEnrollee = (String)fileData.get(56);
        return StringUtils.isNotEmpty((String)officialEnrollee) && officialEnrollee.equals(CODE_NO);
    }

    private boolean isOfficialEnrolleeCriteriaMatched(RawFileDataList fileData) {
        String officialEnrollee = (String)fileData.get(56);
        return StringUtils.isNotEmpty((String)officialEnrollee) && officialEnrollee.equals(CODE_YES);
    }

    private boolean isAutoEnrolledRecordsCriteriaMatched(RawFileDataList fileData) {
        String officialEnrollee = (String)fileData.get(38);
        return officialEnrollee != null && officialEnrollee.equals(CODE_YES);
    }

    private boolean isIneligibleCriteriaMatched(RawFileDataList fileData) {
        String enrollmentStatus = (String)fileData.get(9);
        String ineligibleDate = (String)fileData.get(39);
        return StringUtils.isNotEmpty((String)enrollmentStatus) && EnrollmentStatus.CODE_NOT_ELIGIBLE_INELIGIBLE_DATE.getCode().equals(enrollmentStatus) || enrollmentStatus == null && ineligibleDate != null;
    }

    private boolean isCanceledDeclinedCriteriaMatched(RawFileDataList fileData) {
        String enrollmentStatus = (String)fileData.get(9);
        return StringUtils.isNotEmpty((String)enrollmentStatus) && EnrollmentStatus.CODE_CANCELLED_DECLINED.getCode().equals(enrollmentStatus);
    }

    private boolean isDeceasedBeneficiariesCriteriaMatched(RawFileDataList fileData) {
        String enrollmentStatus = (String)fileData.get(9);
        String dateOfDeath = (String)fileData.get(40);
        return StringUtils.isNotEmpty((String)enrollmentStatus) && (EnrollmentStatus.CODE_DECEASED.getCode().equals(enrollmentStatus) || !EnrollmentStatus.CODE_DECEASED.getCode().equals(enrollmentStatus) && StringUtils.isNotEmpty((String)dateOfDeath));
    }

    private boolean isEnrolleeStatusCriteriaMatched(RawFileDataList fileData) {
        String enrollmentStatus = (String)fileData.get(9);
        return StringUtils.isNotEmpty((String)enrollmentStatus);
    }

    private boolean isPendingMeansTestCriteriaMatched(RawFileDataList fileData) {
        String enrollmentStatus = (String)fileData.get(9);
        return StringUtils.isNotEmpty((String)enrollmentStatus) && EnrollmentStatus.CODE_PENDING_MEANS_TEST_REQUIRED.getCode().equals(enrollmentStatus);
    }
}

