/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.NCOAAddressVerificationFileSummary;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.util.InvalidConfigurationException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class NCOAAddressVerificationFileProcessStatistics
extends ProcessStatistics {
    private static final long serialVersionUID = 8731729340372380614L;
    private int numberOfNoIdentityTraitsRecords;
    private NCOAAddressVerificationFileSummary ncoaAddressVerificationFileSummary;

    public NCOAAddressVerificationFileSummary getNcoaAddressVerificationFileSummary() {
        return this.ncoaAddressVerificationFileSummary;
    }

    public void setNcoaAddressVerificationFileSummary(NCOAAddressVerificationFileSummary ncoaAddressVerificationFileSummary) {
        this.ncoaAddressVerificationFileSummary = ncoaAddressVerificationFileSummary;
    }

    public void setNumberOfNoIdentityTraitsRecords(int numberOfNoIdentityTraitsRecords) {
        this.numberOfNoIdentityTraitsRecords = numberOfNoIdentityTraitsRecords;
    }

    public int getNumberOfNoIdentityTraitsRecords() {
        return this.numberOfNoIdentityTraitsRecords;
    }

    public void incrementNumberOfNoIdentityTraitsRecords() {
        this.incrementNumberOfNoIdentityTraitsRecords(1);
    }

    public void incrementNumberOfNoIdentityTraitsRecords(int recordsCount) {
        this.numberOfNoIdentityTraitsRecords += recordsCount;
        this.incrementNumberOfTotalRecords(recordsCount);
    }

    protected void appendStats(ProcessStatistics stats) {
        NCOAAddressVerificationFileProcessStatistics incoming = (NCOAAddressVerificationFileProcessStatistics)stats;
        this.incrementNumberOfNoIdentityTraitsRecords(incoming.getNumberOfNoIdentityTraitsRecords());
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("numberOfNoIdentityTraitsRecords", this.getNumberOfNoIdentityTraitsRecords());
        if (this.ncoaAddressVerificationFileSummary == null) {
            throw new InvalidConfigurationException("NCOAAddressVerificationFileSummary is null in NCOAAddressVerificationFileProcessStatistics. Cannot generate statistics");
        }
        builder.append("Process Ended: ", (Object)this.getProcessingEndDate());
        builder.append("Total Number of Records Included in the screening process: ", this.ncoaAddressVerificationFileSummary.getCountOfRecordsScreened());
        builder.append("Total Number of Records excluded based on screening criteria: ", this.ncoaAddressVerificationFileSummary.getCountOfRecordsExcluded());
        builder.append("Total Number of Records Excluded based on missing identity traits: ", this.getNumberOfNoIdentityTraitsRecords());
        builder.append("Total Number of Deceased Records identified in the screening process: ", this.ncoaAddressVerificationFileSummary.getCountOfRecordsDeceased());
        builder.append("Total Number of Records sent to AAC: ", this.ncoaAddressVerificationFileSummary.getCountOfRecordsAfterScreening());
        builder.append("Total Number of Files sent to AAC: ", 1);
    }
}

