/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.batchprocess.DataQueryProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MigrateBulkEEProcessStatistics
extends DataQueryProcessStatistics {
    private static final long serialVersionUID = -9119250116423503576L;
    private float totalSuccessfulDuration;
    private int numberOfEEDidNotChangeRecords;
    private int numberOfLettersTriggered;
    private int numberOfBulletinsTriggered;
    private int numberOfHL7MessagesTriggered;
    private int numberOfRecordsNotNeedingEEMigrated;
    private int extrapolatedTarget = 9000000;
    private int parallelFactor = 30;

    public void setNumberOfBulletinsTriggered(int numberOfBulletinsTriggered) {
        this.numberOfBulletinsTriggered = numberOfBulletinsTriggered;
    }

    public void setNumberOfEEDidNotChangeRecords(int numberOfEEDidNotChangeRecords) {
        this.numberOfEEDidNotChangeRecords = numberOfEEDidNotChangeRecords;
    }

    public void setNumberOfHL7MessagesTriggered(int numberOfHL7MessagesTriggered) {
        this.numberOfHL7MessagesTriggered = numberOfHL7MessagesTriggered;
    }

    public void setNumberOfLettersTriggered(int numberOfLettersTriggered) {
        this.numberOfLettersTriggered = numberOfLettersTriggered;
    }

    public void setNumberOfRecordsNotNeedingEEMigrated(int numberOfRecordsNotNeedingEEMigrated) {
        this.numberOfRecordsNotNeedingEEMigrated = numberOfRecordsNotNeedingEEMigrated;
    }

    public float getCurrentAverageSuccessfulDuration() {
        return this.getNumberOfSuccessfulRecords() > 0 ? this.totalSuccessfulDuration / (float)this.getNumberOfSuccessfulRecords() : 0.0f;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("averageDurationPerSuccessfulPerson", this.getCurrentAverageSuccessfulDuration());
        builder.append("numberOfEEDidNotChangeRecords", this.numberOfEEDidNotChangeRecords);
        builder.append("numberOfBulletinsTriggered", this.numberOfBulletinsTriggered);
        builder.append("numberOfHL7MessagesTriggered", this.numberOfHL7MessagesTriggered);
        builder.append("numberOfRecordsNotNeedingEEMigrated", this.numberOfRecordsNotNeedingEEMigrated);
        if (super.getProcessingStartDate() != null && super.getProcessingEndDate() != null && this.getNumberOfTotalRecords() > 0) {
            long durationMillis = super.getProcessingEndDate().getTime() - super.getProcessingStartDate().getTime();
            builder.append("** EXTRAPOLATED Duration (represented in hours) for " + this.extrapolatedTarget + " records", (float)durationMillis / (float)this.getNumberOfTotalRecords() * (float)this.extrapolatedTarget / 3600000.0f);
            builder.append("** EXTRAPOLATED Duration (represented in days) for " + this.extrapolatedTarget + " records", (float)durationMillis / (float)this.getNumberOfTotalRecords() * (float)this.extrapolatedTarget / 8.64E7f);
            if (this.getNumberOfTotalRecords() == 1) {
                builder.append("parallelFactor", this.parallelFactor);
                builder.append("** EXTRAPOLATED Parallel Duration (represented in hours) for " + this.extrapolatedTarget + " records", (float)durationMillis / (float)this.getNumberOfTotalRecords() * (float)this.extrapolatedTarget / 3600000.0f / (float)this.parallelFactor);
                builder.append("** EXTRAPOLATED Parallel Duration (represented in days) for " + this.extrapolatedTarget + " records", (float)durationMillis / (float)this.getNumberOfTotalRecords() * (float)this.extrapolatedTarget / 8.64E7f / (float)this.parallelFactor);
            }
        }
    }

    public int getNumberOfEEDidNotChangeRecords() {
        return this.numberOfEEDidNotChangeRecords;
    }

    public int getNumberOfBulletinsTriggered() {
        return this.numberOfBulletinsTriggered;
    }

    public int getNumberOfHL7MessagesTriggered() {
        return this.numberOfHL7MessagesTriggered;
    }

    public void incrementNumberOfHL7MessagesTriggered(int recordsCount) {
        this.numberOfHL7MessagesTriggered += recordsCount;
    }

    public void incrementNumberOfBulletinsTriggered(int recordsCount) {
        this.numberOfBulletinsTriggered += recordsCount;
    }

    public void incrementNumberOfRecordsNotNeedingEEMigrated() {
        this.incrementNumberOfRecordsNotNeedingEEMigrated(1);
    }

    public void incrementNumberOfRecordsNotNeedingEEMigrated(int count) {
        this.numberOfRecordsNotNeedingEEMigrated += count;
        super.incrementNumberOfTotalRecords(count);
    }

    public int getExtrapolatedTarget() {
        return this.extrapolatedTarget;
    }

    public void setExtrapolatedTarget(int extrapolatedTarget) {
        this.extrapolatedTarget = extrapolatedTarget;
    }

    public int getNumberOfRecordsNotNeedingEEMigrated() {
        return this.numberOfRecordsNotNeedingEEMigrated;
    }

    public int getNumberOfLettersTriggered() {
        return this.numberOfLettersTriggered;
    }

    public void incrementNumberOfLettersTriggered(int recordsCount) {
        this.numberOfLettersTriggered += recordsCount;
    }

    public void incrementNumberOfEEDidNotChangeRecords() {
        this.incrementNumberOfEEDidNotChangeRecords(1);
    }

    public void incrementNumberOfEEDidNotChangeRecords(int count) {
        this.numberOfEEDidNotChangeRecords += count;
    }

    protected void appendStats(ProcessStatistics stats) {
        MigrateBulkEEProcessStatistics incoming = (MigrateBulkEEProcessStatistics)stats;
        this.incrementNumberOfBulletinsTriggered(incoming.getNumberOfBulletinsTriggered());
        this.incrementNumberOfEEDidNotChangeRecords(incoming.getNumberOfEEDidNotChangeRecords());
        this.incrementNumberOfHL7MessagesTriggered(incoming.getNumberOfHL7MessagesTriggered());
        this.incrementNumberOfLettersTriggered(incoming.getNumberOfLettersTriggered());
        this.setNumberOfRecordsNotNeedingEEMigrated(this.getNumberOfRecordsNotNeedingEEMigrated() + incoming.getNumberOfRecordsNotNeedingEEMigrated());
        this.setTotalSuccessfulDuration(this.getTotalSuccessfulDuration() + incoming.getTotalSuccessfulDuration());
    }

    public int getParallelFactor() {
        return this.parallelFactor;
    }

    public void setParallelFactor(int parallelFactor) {
        this.parallelFactor = parallelFactor;
    }

    public float getTotalSuccessfulDuration() {
        return this.totalSuccessfulDuration;
    }

    public void setTotalSuccessfulDuration(float totalSuccessfulDuration) {
        this.totalSuccessfulDuration = totalSuccessfulDuration;
    }

    public void incrementTotalSuccessfulDuration(float successfulDuration) {
        this.totalSuccessfulDuration += successfulDuration;
        this.incrementNumberOfSuccessfulRecords();
    }
}

