/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.MigrateBulkEEProcessStatistics;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.CommonTriggerEvent;
import gov.va.med.esr.service.trigger.CommonTriggerIdentity;
import gov.va.med.fw.batchprocess.AbstractPublishQueryResultsToWorkers;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.service.trigger.TriggerEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

public class MigrateBulkEEProcess
extends AbstractPublishQueryResultsToWorkers {
    private final String CUSTOM_PERSON_IDS = "customPersonIds";
    private final String PREFIX_MAX_NUMBER_TO_MIGRATE = "-size=";
    private String triggerEventName;

    protected ProcessStatistics createProcessStatistics() {
        return new MigrateBulkEEProcessStatistics();
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        if (context.getExecutionArguments() == null) {
            return super.doAcquireData(context);
        }
        if (context.getContextData().containsKey("maxRecordsQueries")) {
            return super.doAcquireData(context);
        }
        if (context.getContextData().containsKey("customPersonIds")) {
            return null;
        }
        Object args = context.getExecutionArguments();
        if (args instanceof Object[]) {
            ArrayList<BigDecimal> personIds = new ArrayList<BigDecimal>();
            Object[] argsArray = (Object[])args;
            for (int i = 0; i < argsArray.length; ++i) {
                personIds.add(new BigDecimal(argsArray[i].toString()));
            }
            context.getContextData().put("customPersonIds", null);
            context.getContextData().put("totalQueryCount", new Integer(personIds.size()));
            return personIds;
        }
        String singleArg = (String)args;
        if (singleArg.startsWith("-size=")) {
            String maxNumberToMigrate = singleArg.substring("-size=".length());
            Integer maxNumber = new Integer(maxNumberToMigrate);
            context.getContextData().put("maxRecordsQueries", maxNumber);
            return super.doAcquireData(context);
        }
        ArrayList<BigDecimal> personIds = new ArrayList<BigDecimal>();
        personIds.add(new BigDecimal(singleArg));
        context.getContextData().put("customPersonIds", null);
        context.getContextData().put("totalQueryCount", new Integer(1));
        return personIds;
    }

    protected TriggerEvent getTriggerEvent(DataQueryProcessExecutionContext context, List acquiredData) {
        ArrayList<Object> personIds = new ArrayList<Object>();
        Iterator itr = acquiredData.iterator();
        Object item = null;
        while (itr.hasNext()) {
            item = itr.next();
            if (item instanceof Object[]) {
                personIds.add(((Object[])item)[0]);
                continue;
            }
            personIds.add(item);
        }
        return new CommonTriggerEvent(this.triggerEventName, personIds, new CommonTriggerIdentity(CommonTrigger.DestinationType.BATCH_PROCESS));
    }

    public String getTriggerEventName() {
        return this.triggerEventName;
    }

    public void setTriggerEventName(String triggerEventName) {
        this.triggerEventName = triggerEventName;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerEventName, (String)"triggerEventName is required");
    }
}

