/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.io.RawFileDataContainer;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.InvalidArgumentException;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class LoadRegistryFileData
extends AbstractEntity
implements RawFileDataContainer {
    private static final long serialVersionUID = -1370346746640850300L;
    protected static final String LAST_NAME = "lastName";
    protected static final String FIRST_NAME = "firstName";
    protected static final String MIDDLE_NAME = "middleName";
    protected static final String SUFFIX = "prefix";
    protected static final String PREFIX = "suffix";
    protected static final String EDUCATIONAL_DEGREE = "educationalDegree";
    protected static final String SSN = "ssn";
    protected static final String REGISTRY_TYPE = "registryType";
    protected static final String EXCEPTION_REASON = "exceptionReason";
    protected final int SSN_LENGTH = 9;
    private Registry registry;
    private String exceptionReason;

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String getExceptionReason() {
        return this.exceptionReason;
    }

    public void setExceptionReason(String exceptionReason) {
        this.exceptionReason = exceptionReason;
    }

    protected String transformLookup(Lookup lookup) {
        return lookup == null ? null : lookup.getCode();
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("registry", (Object)this.registry);
        builder.append(EXCEPTION_REASON, (Object)this.exceptionReason);
    }

    protected Boolean buildBooleanValue(String value) throws InvalidArgumentException {
        Boolean convertedValue = null;
        if (!StringUtils.isEmpty((String)value)) {
            if ("y".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
                convertedValue = Boolean.TRUE;
            } else if ("n".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
                convertedValue = Boolean.FALSE;
            } else {
                throw new InvalidArgumentException("Invalid argument to build boolean value: " + value, null);
            }
        }
        return convertedValue;
    }

    protected Integer buildIntegerValue(String value) throws InvalidArgumentException {
        return StringUtils.isEmpty((String)value) ? null : Integer.valueOf(value);
    }

    protected String buildSsnValue(String value) throws InvalidArgumentException {
        String ssn = StringUtils.stripToNull((String)value);
        if (StringUtils.isEmpty((String)ssn)) {
            return ssn;
        }
        return StringUtils.leftPadWithZero((String)ssn, (int)9);
    }
}

