/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.Validate;

public class Initial640KLetterBatch
extends AbstractDataQueryIncrementalProcess {
    private PersonService personService;
    private LookupService lookupService;
    private CommsLetterRequestService letterRequestService = null;
    private ComLetterTemplateType formNumber = null;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initial 640K Letter batch process: Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        try {
            this.formNumber = this.getComLetterTemplateType(ComLetterTemplateType.FORM_NUMBER_640K.getName());
        }
        catch (RuleException ex) {
            return;
        }
        if (this.formNumber == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            block10: {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal personId = (BigDecimal)row[0];
                PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(personId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
                }
                try {
                    this.processRecord(key, row);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing " + this.getProcessName() + " for person " + personId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block10;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!context.getProcessStatistics().isTotalNumberMod(5)) continue;
            this.updateJobResult((DataProcessExecutionContext)context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    protected void processRecord(PersonEntityKey key, Object[] dataRow) throws Exception {
        String VPID2 = (String)dataRow[1];
        Person person = this.personService.getPerson(key);
        if (person == null) {
            throw new RuntimeException("Unable to find Person for VPID: " + VPID2);
        }
        this.letterRequestService.requestAacLetter(person, new LetterTriggerIdentity(this.formNumber, LetterTrigger.CategoryType.VETERAN_LETTER), null, LetterTriggerEvent.MANUAL_MAIL, null);
    }

    private ComLetterTemplateType getComLetterTemplateType(String type) throws RuleException {
        if (type != null) {
            try {
                return this.getLookupService().getComLetterTemplateTypeByCode(type);
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get com letter template type", (Throwable)e);
            }
        }
        return null;
    }

    public CommsLetterRequestService getLetterRequestService() {
        return this.letterRequestService;
    }

    public void setLetterRequestService(CommsLetterRequestService letterRequestService) {
        this.letterRequestService = letterRequestService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService);
        Validate.notNull((Object)this.lookupService);
        Validate.notNull((Object)this.letterRequestService);
    }
}

