/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.common.model.lookup.HandBookRequestStatusType;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StopWatchLogger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;

public class HandbookBulkGenerateProcess
extends AbstractDataQueryIncrementalProcess {
    private static final String PARAM_BATCHID = "batchreq_id";
    private static final String BATCH_RELEASE_COUNT_QUERY = "handbookBulkGenerateProcess.countPerBatch";
    private static final String IS_PERSON_ALIVE_QUERY = "handbookBulkGenerateProcess.isPersonAlive";
    private static final String PARAM_PERSONID = "person_id";
    private HandBookService handbookService = null;
    private LookupService lookupService = null;
    private Set batchRequests = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Handbook Bulk Generate Process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        StopWatchLogger watch = null;
        for (int i = 0; i < acquiredData.size(); ++i) {
            if (this.logger.isDebugEnabled()) {
                watch = new StopWatchLogger(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + " processData[" + i + "]");
                watch.start();
            }
            BigDecimal personId = (BigDecimal)((Object[])acquiredData.get(i))[0];
            BigDecimal batchRequestId = (BigDecimal)((Object[])acquiredData.get(i))[1];
            BigDecimal releaseControlId = (BigDecimal)((Object[])acquiredData.get(i))[2];
            try {
                if (this.isPersonAlive(personId)) {
                    this.getHandbookService().request400HHandBookMail(personId, null, String.valueOf(batchRequestId), releaseControlId);
                }
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Error adding entry to HandbookMailQueue for person " + personId;
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                continue;
            }
            finally {
                if (this.logger.isDebugEnabled()) {
                    watch.stopAndLog();
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Handbook Bulk Generate Process: Processing complete.");
            this.logger.debug((Object)("Handbook Bulk Generate Process: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("Handbook Bulk Generate Process: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    private boolean isPersonAlive(BigDecimal personId) throws DAOException {
        StopWatchLogger watch = null;
        if (this.logger.isDebugEnabled()) {
            watch = new StopWatchLogger(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + " isPersonAlive(" + personId + ")");
            watch.start();
        }
        HashMap<String, BigDecimal> contextData = new HashMap<String, BigDecimal>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query query = session.getNamedQuery(HandbookBulkGenerateProcess.IS_PERSON_ALIVE_QUERY);
                query.setParameter(HandbookBulkGenerateProcess.PARAM_PERSONID, (Object)((BigDecimal)this.getContextData().get("personId")));
                return query.list();
            }
        };
        List result = (List)this.getDao().execute(callback);
        if (this.logger.isDebugEnabled()) {
            watch.stopAndLog();
        }
        return result != null && !result.isEmpty();
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        int count = 0;
        for (BigDecimal batchRequestId : this.batchRequests) {
            try {
                count = this.getCount(batchRequestId);
                this.updateBatchRequest(batchRequestId, count);
            }
            catch (Exception ex) {
                String errMsg = "Error getting count and updating batch request for request ID = " + batchRequestId;
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
        }
        super.handleDataProcessCompleted(context);
    }

    private int getCount(BigDecimal batchRequestId) throws DAOException {
        HashMap<String, BigDecimal> contextData = new HashMap<String, BigDecimal>();
        contextData.put("batchreqId", batchRequestId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query query = session.getNamedQuery(HandbookBulkGenerateProcess.BATCH_RELEASE_COUNT_QUERY);
                query.setParameter(HandbookBulkGenerateProcess.PARAM_BATCHID, (Object)((BigDecimal)this.getContextData().get("batchreqId")));
                return query.uniqueResult();
            }
        };
        Integer count = (Integer)this.getDao().execute(callback);
        return count == null ? 0 : count;
    }

    private void updateBatchRequest(BigDecimal batchRequestId, int batchSize) throws ServiceException {
        HandBookBatchRequest batchRequest = this.handbookService.getHandbookBatchRequestEntry(EntityKeyFactory.createEntityKey((Serializable)batchRequestId, HandBookBatchRequest.class));
        if (batchRequest == null) {
            throw new ServiceException("HandbookBatchRequest not found for id = " + batchRequestId);
        }
        batchRequest.setBatchReleaseSize(Integer.toString(batchSize));
        HandBookRequestStatusType completedStatus = this.getLookupService().getHandBookRequestStatusTypeByCode(HandBookRequestStatusType.COMPLETED.getCode());
        batchRequest.setHandBookRequestStatus(completedStatus);
        this.handbookService.saveHandBookBatchRequest(batchRequest);
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        StopWatchLogger watch = null;
        if (this.logger.isDebugEnabled()) {
            watch = new StopWatchLogger(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + " doAcquireData");
            watch.start();
        }
        List acquiredData = null;
        try {
            this.batchRequests = new HashSet(this.handbookService.getNewHandBookBatchRequestIds());
            acquiredData = super.doAcquireData(context);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                watch.stopAndLog();
            }
        }
        return acquiredData;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.handbookService, (String)"A HandBookService is needed");
        Validate.notNull((Object)this.lookupService, (String)"A LookupService is needed");
    }

    public HandBookService getHandbookService() {
        return this.handbookService;
    }

    public void setHandbookService(HandBookService handbookService) {
        this.handbookService = handbookService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

