/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CommsExportStatistics;
import gov.va.med.esr.common.batchprocess.HandbookBatchProcessSpawnedThreadTask;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.ThreadPool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class HandbookBatchProcess
extends AbstractDataQueryIncrementalProcess {
    private SystemParameterService paramService;
    private FormattedFileWriter outputFileWriter;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 100;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 100;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;
    private static final String ZERO_SIZE_FILE_NAME = "     N/A           ";
    private int maxToCMS = 100000;
    private final String EMPTY_STRING = "";
    private static final String MAX_TO_CMS = "Maximum number of records to CMS";
    protected static CommsExportStatistics stats = null;
    protected static final String EXTRACT_WRITER = "ExtractDataWriter";
    protected static final String EXCEPTION_WRITER = "ExceptionDataWriter";
    private Writer extractWriter;
    private Writer exceptionWriter;
    private String hbFolder = null;
    private String fileSuffix = null;
    private boolean processing = false;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null) {
            return;
        }
        try {
            this.maxToCMS = new Integer(this.getParamService().getByName(MAX_TO_CMS).getValue());
        }
        catch (ServiceException se) {
            this.logger.error((Object)("Handbook Batch Process: error getting max number of record to CMS. Use default value. Error= " + (Object)((Object)se)));
        }
        if (!this.processing) {
            stats = new CommsExportStatistics();
            stats.setStartTime(new Date());
            this.initFileWriters();
            this.processing = true;
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context) && context.getProcessStatistics().getNumberOfSuccessfulRecords() != this.maxToCMS; ++i) {
            Object[] row = (Object[])acquiredData.get(i);
            this.processEntityData(context, row);
        }
    }

    public void processEntityData(DataQueryProcessExecutionContext context, Object[] acquiredData) {
        if (this.isThreaded()) {
            this.spawnThread(context, acquiredData);
        }
    }

    private void spawnThread(DataQueryProcessExecutionContext context, Object[] acquiredData) {
        try {
            while (HandbookBatchProcess.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            HandbookBatchProcessSpawnedThreadTask task = (HandbookBatchProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            context.getContextData().put(EXTRACT_WRITER, this.extractWriter);
            context.getContextData().put(EXCEPTION_WRITER, this.exceptionWriter);
            task.setContext(context);
            task.setAcquiredData(acquiredData);
            task.setAuditInfo(this.getAuditInfo());
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("HandbookBatchProcessSpawnedThreadTask was interrupted while it was spawning a thread. ", e);
        }
    }

    private void initFileWriters() {
        this.hbFolder = this.getOutputFileWriter().getFileLocation();
        this.fileSuffix = this.getOutputFileWriter().getFileSystemResource((Object)this.getOutputFileWriter().getFileNameAppender().getFileNameSuffix(null)).getFilename();
        this.extractWriter = this.getOutputWriter(this.hbFolder + "ToCMS/CMS_DataExtract_", this.fileSuffix);
        this.exceptionWriter = this.getOutputWriter(this.hbFolder + "Exception/CMS_DataExtract_", this.fileSuffix.replaceAll("hbk", "exception"));
    }

    private void saveToSummaryFile(CommsExportStatistics stats, DataQueryProcessExecutionContext context) {
        stats.setEndTime(new Date());
        stats.setOriginalFileName("CMS_DataExtract_" + this.fileSuffix);
        this.writeFile(this.hbFolder + "Processed/CMS_DataExtract_summary_", this.fileSuffix.replaceAll("hbk", "txt"), this.toSummaryTxt(stats, context));
    }

    private String toSummaryTxt(CommsExportStatistics stats, DataQueryProcessExecutionContext context) {
        StringBuffer str = new StringBuffer("### Handbook Batch Process Execution Statistics ###\n");
        context.getProcessStatistics().setProcessingEndDate(new Date());
        try {
            str.append(context.getProcessStatistics().exportAsCSV());
        }
        catch (Exception e) {
            str.append("Unable to get the execution statistics");
        }
        str.append("\n\nExtract Data Statistics:").append("\nCompletedDateTime: ").append(new Date()).append("\nNumberOfFiles: 1").append("\nNumberLettersSent: ").append(stats.getNumberSent()).append("\nNumberLetterRejected: ").append(stats.getNumberRejected()).append("\nCommunicationsPerFormTxt: \n").append(stats.getHbCountPerFormTableText()).append("\nRejectPerReasonPerFormTxt: \n").append(stats.getRejectPerReasonPerFormText()).append("\nFileNameRecordCountTxt: \n").append(stats.getOriginalFileName()).append("  ").append(stats.getNumberSent());
        return str.toString();
    }

    private Writer getOutputWriter(String fileLocation, String fileName) {
        Writer output = null;
        try {
            File file = new File(fileLocation + fileName);
            output = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            try {
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new RuntimeException("HandbookBatchProcess is unable to generate file to CMS! File= " + fileLocation + fileName + "Exception: " + e);
        }
        return output;
    }

    private void writeFile(String fileLocation, String fileName, String text) {
        Writer output = null;
        try {
            File file = new File(fileLocation + fileName);
            output = new BufferedWriter(new FileWriter(file));
            output.write(text);
        }
        catch (IOException e) {
            throw new RuntimeException("HandbookBatchProcess is unable to generate file to CMS! File= " + fileLocation + fileName + "Exception: " + e);
        }
        finally {
            try {
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
            catch (IOException e1) {}
        }
    }

    private void sendEmailNotification(CommsExportStatistics stats) {
        Hashtable<String, String> dataTab = new Hashtable<String, String>();
        if (stats != null) {
            dataTab.put("CompletedDateTime", stats.getEndTime().toString());
            dataTab.put("NumberOfFiles", "1");
            dataTab.put("NumberLettersSent", stats.getNumberSent() + "");
            dataTab.put("NumberLetterRejected", stats.getNumberRejected() + "");
            dataTab.put("NumberLettersRemailed", stats.getNumberRemailed() + "");
            dataTab.put("CommunicationsPerFormTxt", stats.getHbCountPerFormTableText());
            dataTab.put("RejectPerReasonPerFormTxt", stats.getRejectPerReasonPerFormText());
            dataTab.put("FileNameRecordCountTxt", stats.getOriginalFileName() + "      " + stats.getNumberSent());
        } else {
            dataTab.put("CompletedDateTime", "");
            dataTab.put("NumberOfFiles", "1");
            dataTab.put("NumberLettersSent", "");
            dataTab.put("NumberLetterRejected", "");
            dataTab.put("NumberLettersRemailed", "");
            dataTab.put("CommunicationsPerFormTxt", "");
            dataTab.put("RejectPerReasonPerFormTxt", "");
            dataTab.put("FileNameRecordCountTxt", "");
        }
        try {
            CommsEmailBulletinService emailSrv = (CommsEmailBulletinService)this.getComponent("commsEmailBulletinService");
            emailSrv.sendEmailBulletin(BulletinTrigger.DataType.HANDBOOK_LETTER_PROCESSING, dataTab, null);
        }
        catch (Exception exlog) {
            this.logger.error((Object)("Error while sending bulletin for Handbook Process" + exlog.getMessage()));
        }
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block18: {
            if (this.isThreaded()) {
                try {
                    if (HandbookBatchProcess.getTaskCount(context) == 0) break block18;
                    HandbookBatchProcess handbookBatchProcess = this;
                    synchronized (handbookBatchProcess) {
                        boolean stillProcessing = true;
                        while (stillProcessing) {
                            ((Object)((Object)this)).wait();
                            if (HandbookBatchProcess.getTaskCount(context) != 0) continue;
                            stillProcessing = false;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.throwIllegalStateException("HandbookBatchProcess was interrupted while it was waiting for its spawned threads to complete", e);
                }
                finally {
                    this.getThreadPool(context).stop();
                    this.cleanThreadPool(context);
                }
            }
        }
        this.updateJobResult(context);
        try {
            if (this.extractWriter != null) {
                this.extractWriter.flush();
                this.extractWriter.close();
            }
        }
        catch (IOException e1) {
            this.logger.error((Object)("Unable to close Data Extract File" + e1.getMessage()));
        }
        try {
            if (this.exceptionWriter != null) {
                this.exceptionWriter.flush();
                this.exceptionWriter.close();
            }
        }
        catch (IOException e1) {
            this.logger.error((Object)("Unable to close Data Extract File" + e1.getMessage()));
        }
        this.extractWriter = null;
        this.exceptionWriter = null;
        this.processing = false;
        try {
            this.saveToSummaryFile(stats, (DataQueryProcessExecutionContext)context);
        }
        catch (Exception e1) {
            this.logger.error((Object)("Unable to write summary file " + e1.getMessage()));
        }
        this.sendEmailNotification(stats);
        super.handleDataProcessCompleted(context);
        stats = null;
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("HandbookBatchProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataQueryProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        HandbookBatchProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(HandbookBatchProcess.getTaskCount(context) + adjustment));
        }
    }

    private boolean isThreaded() {
        return StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public FormattedFileWriter getOutputFileWriter() {
        return this.outputFileWriter;
    }

    public void setOutputFileWriter(FormattedFileWriter outputFileWriter) {
        this.outputFileWriter = outputFileWriter;
    }

    public SystemParameterService getParamService() {
        return this.paramService;
    }

    public void setParamService(SystemParameterService paramService) {
        this.paramService = paramService;
    }
}

