/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.HBPRuleDeploymentProcess;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.HealthBenefitPlanService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;

public class HBPRuleDeploymentProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private DataQueryProcessExecutionContext context;
    private BigDecimal acquiredData;
    private HealthBenefitPlanService healthBenefitPlanService;
    private PersonService personService;

    public DataQueryProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataQueryProcessExecutionContext context) {
        this.context = context;
    }

    public BigDecimal getAcquiredData() {
        return this.acquiredData;
    }

    public void setAcquiredData(BigDecimal acquiredData) {
        this.acquiredData = acquiredData;
    }

    public HealthBenefitPlanService getHealthBenefitPlanService() {
        return this.healthBenefitPlanService;
    }

    public void setHealthBenefitPlanService(HealthBenefitPlanService healthBenefitPlanService) {
        this.healthBenefitPlanService = healthBenefitPlanService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() throws Throwable {
        Object threadCreator;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"HBPRuleDeploymentProcessSpawnedThreadTask started");
        }
        Person person = null;
        try {
            PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(this.acquiredData);
            person = this.personService.getPerson(key);
            if (person == null) {
                throw new ServiceException("Unable to find Person with personId= " + this.acquiredData);
            }
            this.healthBenefitPlanService.processHealthBenefitProfile(person);
            this.context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
        }
        catch (Exception e) {
            this.handleFailure(this.context, this.acquiredData, e);
        }
        HBPRuleDeploymentProcess.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
        Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
        synchronized (object) {
            threadCreator.notifyAll();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"HBPRuleDeploymentProcessSpawnedThreadTask ended, notified creator");
        }
        this.context = null;
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleFailure(DataQueryProcessExecutionContext context, Object dataRecord, Exception e) {
        String exceptionText = null;
        exceptionText = e == null ? "Error: Unable to process HBP Person data: " + dataRecord : "Error: Unable to process HBP Person data: " + dataRecord + " because of exception: " + e;
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)exceptionText);
        }
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(dataRecord);
        context.getExceptionData().add(exceptionText + "\n\n");
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String trackTrace = sw.toString();
            context.getExceptionData().add(trackTrace);
        }
    }
}

