/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.GenerateQRYZ21ProcessSpawnedThreadTask;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.util.ThreadPool;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GenerateQRYZ21Process
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 500;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    public static final String GENERATE_QUERYZ21_PROCESS_THREAD_NAME = "GENQUERYZ21THREAD";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 500;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Query increment result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        Object args = context.getExecutionArguments();
        if (args != null) {
            super.setFetchSize(1);
            String singleArg = (String)args;
            BigDecimal[] personArray = new BigDecimal[2];
            personArray[0] = new BigDecimal(singleArg);
            acquiredData.clear();
            acquiredData.add(personArray);
        }
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            Object[] row = (Object[])acquiredData.get(i);
            BigDecimal personId = (BigDecimal)row[0];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
            }
            this.processEntityData(context, personId);
            if (context.getProcessStatistics().isTotalNumberMod(5)) {
                this.updateJobResult((DataProcessExecutionContext)context);
            }
            if (args == null) continue;
            context.setInterrupted(true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getProcessName() + ": Processing of current batch complete."));
            this.logger.debug((Object)(this.getProcessName() + ": Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)(this.getProcessName() + ": Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public void processEntityData(DataQueryProcessExecutionContext context, BigDecimal acquiredData) {
        if (this.isThreaded()) {
            this.spawnThread(context, acquiredData);
        }
    }

    private void spawnThread(DataQueryProcessExecutionContext context, BigDecimal acquiredData) {
        try {
            while (GenerateQRYZ21Process.getTaskCount((DataProcessExecutionContext)context) >= this.throttleTaskCountThreshold) {
                Thread.sleep(this.spawnRetryPeriod);
            }
            this.initThreadCreatorAndIncrementTaskCount(context);
            ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
            GenerateQRYZ21ProcessSpawnedThreadTask task = (GenerateQRYZ21ProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
            task.setContext(context);
            task.setAuditInfo(this.getAuditInfo());
            task.setAcquiredData(acquiredData);
            task.setProcessName(this.getProcessName());
            threadPool.invokeLater((Runnable)((Object)task));
        }
        catch (InterruptedException e) {
            this.throwIllegalStateException("GenerateQRYZ21ProcessSpawnedThreadTask was interrupted while it was spawning a thread. ", e);
        }
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block10: {
            if (this.isThreaded()) {
                try {
                    if (GenerateQRYZ21Process.getTaskCount(context) == 0) break block10;
                    GenerateQRYZ21Process generateQRYZ21Process = this;
                    synchronized (generateQRYZ21Process) {
                        boolean stillProcessing = true;
                        while (stillProcessing) {
                            ((Object)((Object)this)).wait();
                            if (GenerateQRYZ21Process.getTaskCount(context) != 0) continue;
                            stillProcessing = false;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.throwIllegalStateException("GenerateQRYZ21Process was interrupted while it was waiting for its spawned threads to complete", e);
                }
                finally {
                    this.getThreadPool(context).stop();
                    this.cleanThreadPool(context);
                }
            }
        }
        super.handleDataProcessCompleted(context);
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("GenerateQRYZ21ProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataQueryProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        GenerateQRYZ21Process.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(GenerateQRYZ21Process.getTaskCount(context) + adjustment));
        }
    }

    private boolean isThreaded() {
        return StringUtils.isNotBlank((String)this.spawnedTaskId);
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

