/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.esr.service.IRSTransmissionService;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class GenerateIRSTransmissionProcess
extends AbstractDataQueryIncrementalProcess {
    private static final int DEFAULT_THREAD_POOL_SIZE = 1;
    private static final int DEFAULT_FETCH_SIZE = 110;
    private static final int DEFAULT_JOB_RESULT_UPDATE_INTERVAL = 100;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    public static final String TRANSMISSION_SIZE = "IRS Transmission Size";
    private SystemParameterService systemParameterService = null;
    int maxBatchSize;
    private int threadPoolSize = 1;
    private int fetchSize = 110;
    private String spawnedTaskId;
    private String calendarYear = null;
    private String startDay = "-01-01";
    private ArrayList<BigDecimal> batch = null;
    private int numRecs = 0;
    private IRSTransmissionService irsTransmissionService = null;
    private PersonService personService;
    private MECPeriodDAO mecPeriodDAO = null;
    private PersonMergeService personMergeService;
    private String BATCH_TYPE = "V";
    private String CORRECTION_IND = "O";

    protected void executeProcess(DataProcessExecutionContext context) throws Exception {
        this.setThreadPoolSize(1);
        String args = (String)context.getExecutionArguments();
        if (!StringUtils.isEmpty((String)args)) {
            String[] params = args.split(",");
            if (params != null && params.length == 2) {
                this.setThreadPoolSize(Integer.valueOf(params[0].trim()));
                this.calendarYear = params[1].trim();
            } else {
                this.setThreadPoolSize(Integer.valueOf(args));
            }
        }
        if (this.calendarYear == null) {
            Calendar prevYear = Calendar.getInstance();
            prevYear.add(1, -1);
            this.calendarYear = Integer.toString(prevYear.get(1));
        }
        String startDate = this.calendarYear + this.startDay;
        String size = this.getSystemParameterService().getByName(TRANSMISSION_SIZE).getValue();
        this.maxBatchSize = Integer.valueOf(size);
        this.setFetchSize(this.maxBatchSize);
        this.batch = new ArrayList();
        this.logger.debug((Object)("threads: " + this.getThreadPoolSize()));
        this.logger.debug((Object)("year: " + this.calendarYear));
        this.setParamNames(new String[]{"startDate", "taxYear"});
        this.setParamValues(new String[]{startDate, this.calendarYear});
        this.setFetchSize(this.maxBatchSize);
        super.executeProcess(context);
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        List acquiredData = null;
        acquiredData = this.executeQuery(context);
        return acquiredData;
    }

    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        DataQueryDetail currentQuery = context.getCurrentDataQuery();
        List results = this.getDao().find(currentQuery.getQuery().getQuery(), currentQuery.getQuery().getParamNames(), currentQuery.getQuery().getParamValues(), this.numRecs, this.maxBatchSize, this.maxBatchSize);
        this.numRecs += this.maxBatchSize;
        return results;
    }

    protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null) {
            return;
        }
        ArrayList<BigDecimal> submission = null;
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted((DataProcessExecutionContext)context); ++i) {
            if (acquiredData.get(i) instanceof Object[]) {
                Object[] row = (Object[])acquiredData.get(i);
                BigDecimal val = (BigDecimal)row[0];
                this.batch.add(val);
                continue;
            }
            this.batch.add((BigDecimal)acquiredData.get(i));
        }
        submission = new ArrayList<BigDecimal>(this.batch);
        this.batch.clear();
        this.processEntityData(context, submission, this.calendarYear);
    }

    public void processEntityData(DataQueryProcessExecutionContext context, ArrayList<BigDecimal> submitBatch, String calendarYear) {
        this.processBatch(context, submitBatch, calendarYear);
    }

    public void processBatch(DataQueryProcessExecutionContext context, ArrayList<BigDecimal> submitBatch, String calendarYear) {
        BigDecimal personId = null;
        ArrayList<IRS1095B> list = new ArrayList<IRS1095B>();
        IRS1095B vetRecord = null;
        MECPeriod period = null;
        try {
            for (int i = 0; i < submitBatch.size(); ++i) {
                if (this.shouldUpdateJobResult(context)) {
                    this.updateJobResult((DataProcessExecutionContext)context);
                }
                try {
                    personId = submitBatch.get(i);
                    if (this.getPersonMergeService().hasDeprecatedRecord(CommonEntityKeyFactory.createPersonIdEntityKey(personId))) {
                        this.logger.error((Object)("Skipping Deprecated record found for person: " + personId));
                        continue;
                    }
                    period = new MECPeriod();
                    period = this.combineAllPeriods(personId);
                    vetRecord = new IRS1095B();
                    vetRecord = this.build1095(period);
                    if (vetRecord == null) {
                        this.logger.error((Object)("Failed to build 1095 from person: " + personId));
                        context.getProcessStatistics().incrementNumberOfErrorRecords();
                        continue;
                    }
                    list.add(vetRecord);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    continue;
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Batch sumission failed to process record: " + personId + " " + ex.getMessage()));
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                }
            }
            if (list != null && list.size() > 0) {
                this.getIrsTransmissionService().sendSubmit(list, this.BATCH_TYPE, this.CORRECTION_IND, calendarYear);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown Exception in GenerateIRSSubmission: " + ex.getMessage()));
        }
    }

    private MECPeriod combineAllPeriods(BigDecimal personId) {
        MECPeriod period = new MECPeriod();
        period.setPersonId(personId);
        HashMap coverageMap = new HashMap();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        Calendar cal = Calendar.getInstance();
        try {
            List allPeriods = this.getMecPeriodDAO().getByPersonId(personId);
            Calendar start = Calendar.getInstance();
            start.clear();
            start.set(1, Integer.valueOf(this.calendarYear));
            start.set(2, 0);
            start.set(5, 1);
            if (allPeriods != null) {
                for (int i = 0; i < allPeriods.size(); ++i) {
                    int monthEnd;
                    int monthStart;
                    MECPeriod partial = (MECPeriod)((Object)allPeriods.get(i));
                    if (partial.getMecEndDate() != null && partial.getMecEndDate().before(start.getTime())) continue;
                    if (partial.getMecStartDate().before(start.getTime()) && partial.getMecEndDate() == null) {
                        period.setCoveredAll12Months(true);
                        period.setCoverageMonths(this.completeMap());
                        break;
                    }
                    if (partial.getMecStartDate().before(start.getTime())) {
                        cal.setTime(partial.getMecStartDate());
                        monthStart = 1;
                        if (partial.getMecEndDate() == null) {
                            monthEnd = 12;
                        } else {
                            cal.setTime(partial.getMecEndDate());
                            monthEnd = cal.get(2) + 1;
                        }
                        this.buildMap(monthStart, monthEnd, coverageMap);
                        continue;
                    }
                    cal.setTime(partial.getMecStartDate());
                    monthStart = cal.get(2) + 1;
                    if (partial.getMecEndDate() == null) {
                        monthEnd = 12;
                    } else {
                        cal.setTime(partial.getMecEndDate());
                        monthEnd = cal.get(2) + 1;
                    }
                    this.buildMap(monthStart, monthEnd, coverageMap);
                }
            }
            boolean all = true;
            for (int i = 1; i <= 12; ++i) {
                if (coverageMap.containsKey(Integer.toString(i))) continue;
                all = false;
            }
            if (all) {
                period.setCoveredAll12Months(true);
            }
            period.setCoverageMonths(coverageMap);
        }
        catch (Exception ex) {
            this.logger.error((Object)("GenerateIRSSubmitProcess Failed to combine MECPeriods for person: " + personId + " reason:" + ex.getMessage()));
        }
        return period;
    }

    private void buildMap(int start, int end, HashMap coverageMap) {
        for (int i = start; i <= end; ++i) {
            coverageMap.put(Integer.toString(i), true);
        }
    }

    private HashMap completeMap() {
        HashMap<String, Boolean> fullYear = new HashMap<String, Boolean>();
        for (int i = 1; i <= 12; ++i) {
            fullYear.put(Integer.toString(i), true);
        }
        return fullYear;
    }

    private IRS1095B build1095(MECPeriod period) {
        IRS1095B rec = null;
        if (period != null) {
            try {
                Person person = this.personService.getPerson(new PersonIdEntityKeyImpl(period.getPersonId()));
                rec = new IRS1095B(person);
                rec.setMecPeriod(period);
            }
            catch (ServiceException e) {
                this.logger.error((Object)("Generate IRS Process Failed to Retrieve person by id:" + period.getPersonId() + " , message:" + e.getMessage()));
            }
            catch (Exception ex) {
                this.logger.error((Object)("GenerateIRSSubmitProcess Failed to build1095 for person: " + period.getPersonId() + " reason:" + ex.getMessage()));
            }
        }
        return rec;
    }

    protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(100);
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public IRSTransmissionService getIrsTransmissionService() {
        return this.irsTransmissionService;
    }

    public void setIrsTransmissionService(IRSTransmissionService irsTransmissionService) {
        this.irsTransmissionService = irsTransmissionService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public MECPeriodDAO getMecPeriodDAO() {
        return this.mecPeriodDAO;
    }

    public void setMecPeriodDAO(MECPeriodDAO mecPeriodDAO) {
        this.mecPeriodDAO = mecPeriodDAO;
    }

    public PersonMergeService getPersonMergeService() {
        return this.personMergeService;
    }

    public void setPersonMergeService(PersonMergeService personMergeService) {
        this.personMergeService = personMergeService;
    }
}

