/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.DateOfDeathImportData;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;

public class DateOfDeathFileData
extends AbstractDataFileSingleRowIncrementProcess {
    private PersonService personService;
    private LookupService lookupService;
    private DemographicService demographicService;
    private static final long serialVersionUID = 9062379406331204087L;

    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        if (bean == null || !(bean instanceof DateOfDeathImportData)) {
            return false;
        }
        DateOfDeathImportData dodData = (DateOfDeathImportData)((Object)bean);
        boolean success = this.processRecord(dodData);
        return success;
    }

    private boolean processRecord(DateOfDeathImportData dodData) {
        boolean success = false;
        Person incoming = null;
        Person person = this.lookupPerson(dodData.getDodData().getVpid());
        if (person != null) {
            incoming = (Person)((Object)person.clone());
            success = this.updatePerson(incoming, dodData.getDodData().getDateOfDeath());
        }
        if (success) {
            Person updated = null;
            try {
                updated = this.getDemographicService().processDeathRecordFromIdm(incoming);
            }
            catch (ServiceException ex) {
                System.out.println("Exception after the demographic call");
                this.logger.error((Object)("Error processing the Death Record from Idm" + (Object)((Object)ex)));
            }
            if (updated != null) {
                success = true;
            }
        }
        return success;
    }

    private Person lookupPerson(String vpid) {
        Person person = null;
        try {
            VPIDEntityKey vpidEntityKey = CommonEntityKeyFactory.createVPIDEntityKey(vpid);
            person = this.getPersonService().getPerson(vpidEntityKey);
        }
        catch (ServiceException e) {
            this.logger.error((Object)"Error retrieving person vpid entity key");
        }
        return person;
    }

    private boolean updatePerson(Person person, Date dateOfDeath) {
        boolean success = false;
        DeathRecord deathRecord = person.getDeathRecord();
        if (deathRecord == null) {
            deathRecord = new DeathRecord();
            person.setDeathRecord(deathRecord);
            this.updateDeathRecord(deathRecord, dateOfDeath);
            success = true;
        }
        return success;
    }

    private void updateDeathRecord(DeathRecord deathRecord, Date dateOfDeath) {
        deathRecord.setDeathDate(ImpreciseDateUtils.createImpreciseDateWithoutTime(dateOfDeath));
        deathRecord.setDeathReportDate(new Date());
        try {
            deathRecord.setDataSource(this.lookupService.getDeathDataSourceByCode(DeathDataSource.CODE_DEATH_CERT_ON_FILE.getCode()));
            deathRecord.setFacilityReceived(this.lookupService.getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
        }
        catch (UnknownLookupTypeException e) {
        }
        catch (UnknownLookupCodeException unknownLookupCodeException) {
            // empty catch block
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }
}

