/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.fw.util.StringUtils;

public class DateFieldTransformer
extends gov.va.med.fw.io.writer.DateFieldTransformer {
    private static final String LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT = "yyyy";
    private static final String UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT = "YYYY";
    private static final String LOWER_CASE_TWO_DIGIT_YEAR_FORMAT = "yy";
    private static final String UPPER_CASE_TWO_DIGIT_YEAR_FORMAT = "YY";
    private static final String LOWER_CASE_MONTH_FORMAT = "mm";
    private static final String UPPER_CASE_MONTH_FORMAT = "MM";
    private static final String LOWER_CASE_DAY_FORMAT = "dd";
    private static final String UPPER_CASE_DAY_FORMAT = "DD";
    private boolean formatImprecise = false;

    public Object transformData(String fieldName, Object data) throws Exception {
        Object transformedVal = data;
        if (data != null && data instanceof ImpreciseDate) {
            ImpreciseDate date = (ImpreciseDate)data;
            if (date.isPrecise()) {
                transformedVal = super.transformData(fieldName, (Object)date.getDate());
            } else if (this.formatImprecise) {
                transformedVal = this.formatImpreciseDate(date);
            } else {
                String transformedValStr = date.getString();
                transformedVal = transformedValStr;
            }
        } else {
            transformedVal = super.transformData(fieldName, data);
        }
        return transformedVal;
    }

    private String formatImpreciseDate(ImpreciseDate date) {
        String defaultFormat;
        String formattedDate = defaultFormat = this.getDateFormat();
        if (date.getString() != null && date.getString().length() >= 4) {
            String day;
            String string = date.getString();
            String year = string.substring(0, 4);
            String month = date.isMonthPrecise() ? string.substring(4, 6) : "00";
            String string2 = day = date.isDayPrecise() ? string.substring(6, 8) : "00";
            if (StringUtils.contains((String)formattedDate, (String)LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT)) {
                formattedDate = StringUtils.replace((String)formattedDate, (String)LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT, (String)year);
            } else if (StringUtils.contains((String)formattedDate, (String)UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT)) {
                formattedDate = StringUtils.replace((String)formattedDate, (String)UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT, (String)year);
            } else if (StringUtils.contains((String)formattedDate, (String)UPPER_CASE_TWO_DIGIT_YEAR_FORMAT)) {
                formattedDate = StringUtils.replace((String)formattedDate, (String)UPPER_CASE_TWO_DIGIT_YEAR_FORMAT, (String)year.substring(2, 4));
            } else if (StringUtils.contains((String)formattedDate, (String)LOWER_CASE_TWO_DIGIT_YEAR_FORMAT)) {
                formattedDate = StringUtils.replace((String)formattedDate, (String)LOWER_CASE_TWO_DIGIT_YEAR_FORMAT, (String)year.substring(2, 4));
            }
            if (month != null) {
                if (StringUtils.contains((String)formattedDate, (String)UPPER_CASE_MONTH_FORMAT)) {
                    formattedDate = StringUtils.replace((String)formattedDate, (String)UPPER_CASE_MONTH_FORMAT, (String)month);
                } else if (StringUtils.contains((String)formattedDate, (String)LOWER_CASE_MONTH_FORMAT)) {
                    formattedDate = StringUtils.replace((String)formattedDate, (String)LOWER_CASE_MONTH_FORMAT, (String)month);
                }
            }
            if (day != null) {
                if (StringUtils.contains((String)formattedDate, (String)UPPER_CASE_DAY_FORMAT)) {
                    formattedDate = StringUtils.replace((String)formattedDate, (String)UPPER_CASE_DAY_FORMAT, (String)day);
                } else if (StringUtils.contains((String)formattedDate, (String)LOWER_CASE_DAY_FORMAT)) {
                    formattedDate = StringUtils.replace((String)formattedDate, (String)LOWER_CASE_DAY_FORMAT, (String)day);
                }
            }
        }
        return formattedDate;
    }

    public boolean isFormatImprecise() {
        return this.formatImprecise;
    }

    public void setFormatImprecise(boolean formatImprecise) {
        this.formatImprecise = formatImprecise;
    }
}

