/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CampLejeuneImportData;
import gov.va.med.esr.common.batchprocess.CampLejeuneImportProcess;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.CampLejeuneService;
import gov.va.med.fw.batchprocess.CampLejeuneImportProcessStatistics;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.support.AbstractSpawnedThreadTask;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.OptimisticLockingFailureException;

public class CampLejeuneImportProcessSpawnedThreadTask
extends AbstractSpawnedThreadTask {
    private static final int DEFAULT_OPTIMSTIC_RETRIES = 5;
    public static final String ERROR_KEYWORD = "Exception Processing CLEAR Record: ";
    private DataFileProcessExecutionContext context;
    private List dataRecords;
    private CampLejeuneService campLejeuneService;
    private int optimisticLockRetries = 5;

    public DataFileProcessExecutionContext getContext() {
        return this.context;
    }

    public void setContext(DataFileProcessExecutionContext context) {
        this.context = context;
    }

    public int getOptimisticLockRetries() {
        return this.optimisticLockRetries;
    }

    public void setOptimisticLockRetries(int optimisticLockRetries) {
        this.optimisticLockRetries = optimisticLockRetries;
    }

    public List getDataRecords() {
        return this.dataRecords;
    }

    public void setDataRecords(List dataRecords) {
        this.dataRecords = dataRecords;
    }

    public CampLejeuneService getCampLejeuneService() {
        return this.campLejeuneService;
    }

    public void setCampLejeuneService(CampLejeuneService campLejeuneService) {
        this.campLejeuneService = campLejeuneService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void executeTask() throws Throwable {
        Object threadCreator;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"CampLejeuneImportProcessSpawnedThreadTask started");
        }
        block6: for (int i = 0; this.dataRecords != null && i < this.dataRecords.size() && !this.context.isInterrupted(); ++i) {
            CampLejeuneImportData dataRecord = (CampLejeuneImportData)((Object)this.dataRecords.get(i));
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing dataRecord #" + i));
                }
                int numberOfRetries = this.optimisticLockRetries;
                boolean optimisticLockSuccess = false;
                while (numberOfRetries > 0 && !optimisticLockSuccess) {
                    try {
                        CampLejeuneImportProcessStatistics stats;
                        Person incoming = this.campLejeuneService.findPersonWithCLEARData(dataRecord);
                        String[] oldNewErr = this.campLejeuneService.processCLEARData(incoming);
                        if (!StringUtils.isEmpty((String)oldNewErr[2])) {
                            stats = (CampLejeuneImportProcessStatistics)this.context.getProcessStatistics();
                            stats.incrementNumberOfSuccessfulRecords();
                            stats.addDetailUnsuccess(dataRecord.getVeteranIdentifiers(), oldNewErr[2] + "\n");
                            continue block6;
                        }
                        optimisticLockSuccess = true;
                        stats = (CampLejeuneImportProcessStatistics)this.context.getProcessStatistics();
                        stats.incrementNumberOfSuccessfulRecords();
                        stats.addDetailSuccess(dataRecord.getVeteranIdentifiers(), oldNewErr[0], oldNewErr[1]);
                    }
                    catch (OptimisticLockingFailureException ole) {
                        --numberOfRetries;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Encountered OptimisticLockingFailureException, # of retries remaining = " + numberOfRetries));
                        }
                        if (numberOfRetries != 0) continue;
                        throw new ServiceException("Exhausted number of retries (" + this.optimisticLockRetries + ") for OptimisticLockingFailureException.");
                    }
                }
                continue;
            }
            catch (Exception e) {
                this.handleFailure(this.context, dataRecord, e);
            }
        }
        CampLejeuneImportProcess.adjustTaskCount((DataProcessExecutionContext)this.context, -1);
        Object object = threadCreator = this.getThreadCreator((DataProcessExecutionContext)this.context);
        // MONITORENTER : object
        threadCreator.notifyAll();
        // MONITOREXIT : object
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"CampLejeuneImportProcessSpawnedThreadTask ended, notified creator");
        }
        this.context = null;
    }

    private String getEnrollmentPriority(EnrollmentDetermination enroll) {
        if (enroll != null && enroll.getPriorityGroup() != null) {
            String priority = enroll.getPriorityGroup().getDescription();
            if (enroll.getPrioritySubGroup() != null) {
                priority = priority + enroll.getPrioritySubGroup().getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group", "");
            return priority.replaceAll("'", "");
        }
        return "";
    }

    private Object getThreadCreator(DataProcessExecutionContext context) {
        return context.getContextData().get("threadCreator");
    }

    private void handleFailure(DataFileProcessExecutionContext context, CampLejeuneImportData dataRecord, Exception e) {
        CampLejeuneImportProcessStatistics stats = (CampLejeuneImportProcessStatistics)context.getProcessStatistics();
        String errReason = null;
        errReason = e == null ? "Unknown Exception\n" : e.getMessage();
        stats.incrementNumberOfErrorRecords();
        stats.addDetailUnsuccess(dataRecord.getVeteranIdentifiers(), errReason);
    }
}

