/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.persistent.report.ReportDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.CampLejeuneImportProcessStatistics;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ExceptionWriterProcessCompletedHandler;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.security.SecurityContextHelper;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class CampLejeuneImportProcessCompletedHandler
extends ExceptionWriterProcessCompletedHandler {
    private static int FIRST_EXCETPION = 0;
    private FormattedFileWriter successFileWriter;
    private FormattedFileWriter unSuccessFileWriter;
    private String toEmailList = null;
    private CommsEmailBulletinService bulletinService = null;
    private String renameInputFileExtension;
    private String renameInputFileRoot;
    private LookupService lookupService = null;
    private ReportDAO reportDAO = null;

    public String getRenameInputFileExtension() {
        return this.renameInputFileExtension;
    }

    public void setRenameInputFileExtension(String renameInputFileExtension) {
        this.renameInputFileExtension = renameInputFileExtension;
    }

    public String getRenameInputFileRoot() {
        return this.renameInputFileRoot;
    }

    public void setRenameInputFileRoot(String renameInputFileRoot) {
        this.renameInputFileRoot = renameInputFileRoot;
    }

    protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
        Date executionStartDate = context.getProcessStatistics().getProcessingStartDate();
        return executionStartDate;
    }

    public void dataProcessingComplete(DataProcessExecutionContext context) {
        File inputFile;
        this.writeDetailUnsuccessReport(context);
        this.writeDetailSuccessReport(context);
        if (!context.isInterrupted() && context instanceof DataFileProcessExecutionContext && !this.renameFile(inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile())) {
            throw new IllegalStateException("Unable to rename input file: " + inputFile.getName());
        }
    }

    public void writeDetailSuccessReport(DataProcessExecutionContext context) {
        CampLejeuneImportProcessStatistics stats = (CampLejeuneImportProcessStatistics)context.getProcessStatistics();
        String succData = stats.getDetailSuccess();
        if (!StringUtils.isEmpty((String)succData) && succData.split("\n").length > 1) {
            CompletedReport report = new CompletedReport();
            report.setCompletedDate(Calendar.getInstance().getTime());
            report.setUser(new ESRUserPrincipalImpl(SecurityContextHelper.getSecurityContext().getUserPrincipal().getName()));
            try {
                report.setStandardReport(this.lookupService.getStandardReportByCode(StandardReport.CODE_CLR_01.getCode()));
                report.setFileType(this.lookupService.getReportExportedTypeByCode(ReportExportedType.CSV.getCode()));
            }
            catch (Exception ex) {
                this.logger.error((Object)("Failed to lookup CLEAR Import Report Type:" + ex));
            }
            report.setReportFileContent(succData.getBytes());
            try {
                this.reportDAO.saveCompletedReport(report);
            }
            catch (DAOException e) {
                throw new IllegalStateException("Failed to persist CLEAR Import Detail Successful Report", e);
            }
        }
    }

    public void writeDetailUnsuccessReport(DataProcessExecutionContext context) {
        CampLejeuneImportProcessStatistics stats = (CampLejeuneImportProcessStatistics)context.getProcessStatistics();
        String unsuccData = stats.getDetailUnsuccess();
        if (!StringUtils.isEmpty((String)unsuccData) && unsuccData.split("\n").length > 1) {
            CompletedReport report = new CompletedReport();
            report.setCompletedDate(Calendar.getInstance().getTime());
            report.setUser(new ESRUserPrincipalImpl(SecurityContextHelper.getSecurityContext().getUserPrincipal().getName()));
            try {
                report.setStandardReport(this.lookupService.getStandardReportByCode(StandardReport.CODE_CLR_02.getCode()));
                report.setFileType(this.lookupService.getReportExportedTypeByCode(ReportExportedType.CSV.getCode()));
            }
            catch (Exception ex) {
                this.logger.error((Object)("Failed to lookup CLEAR Import Report Type:" + ex));
            }
            report.setReportFileContent(unsuccData.getBytes());
            try {
                this.reportDAO.saveCompletedReport(report);
            }
            catch (DAOException e) {
                throw new IllegalStateException("Failed to persist CLEAR Import Detail Unsuccessful Report", e);
            }
        }
    }

    private String getVeteranIdentifiers(String[] strs, boolean isParseError) {
        if (isParseError) {
            String rawData = StringUtils.remove((String)strs[0], (String)"Error processing data: ");
            String[] fields = rawData.split("\\|");
            return new StringBuffer("|").append(fields[3]).append("|").append(fields[2]).append("|").append(fields[5]).append("|").append(fields[7]).append("|").append(fields[8]).append("|").append(strs[1]).toString();
        }
        return new StringBuffer(StringUtils.remove((String)strs[0], (String)"Exception Processing CLEAR Record: ")).append("|").append(strs[1]).toString();
    }

    protected boolean renameFile(File inputFile) {
        String inputFilePath = inputFile.getParent();
        StringBuffer inputFileNameRoot = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(inputFile.getName(), ".");
        int tokenCount = st.countTokens();
        for (int i = 1; i < tokenCount; ++i) {
            inputFileNameRoot.append(st.nextToken());
            if (i == tokenCount - 1) continue;
            inputFileNameRoot.append(".");
        }
        if (tokenCount == 1) {
            inputFileNameRoot.append(inputFile.getName());
        }
        String newFileName = null;
        newFileName = this.renameInputFileRoot != null ? this.renameInputFileRoot + this.renameInputFileExtension : inputFileNameRoot.toString() + this.renameInputFileExtension;
        File newFile = new File(inputFilePath + File.separator + newFileName);
        int i = 1;
        while (newFile.exists()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Can not rename file to " + newFile.getName() + " since it exists already.  Trying one up number extension"));
            }
            newFile = new File(inputFilePath + File.separator + newFileName + i++);
        }
        boolean result = inputFile.renameTo(newFile);
        inputFile.setLastModified(new Date().getTime());
        return result;
    }

    public FormattedFileWriter getSuccessFileWriter() {
        return this.successFileWriter;
    }

    public void setSuccessFileWriter(FormattedFileWriter successFileWriter) {
        this.successFileWriter = successFileWriter;
    }

    public FormattedFileWriter getUnSuccessFileWriter() {
        return this.unSuccessFileWriter;
    }

    public void setUnSuccessFileWriter(FormattedFileWriter unSuccessFileWriter) {
        this.unSuccessFileWriter = unSuccessFileWriter;
    }

    public String getToEmailList() {
        return this.toEmailList;
    }

    public void setToEmailList(String toEmailList) {
        this.toEmailList = toEmailList;
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public ReportDAO getReportDAO() {
        return this.reportDAO;
    }

    public void setReportDAO(ReportDAO reportDAO) {
        this.reportDAO = reportDAO;
    }
}

