/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.CampLejeuneImportProcessSpawnedThreadTask;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.CampLejeuneImportProcessStatistics;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.util.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CampLejeuneImportProcess
extends AbstractDataFileIncrementalProcess {
    LookupService lookupService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THROTTLE_TASKCOUNT_THREASHOLD = 100;
    private static final int DEFAULT_SPAWN_RETRY_PERIOD = 3000;
    private static final int DEFAULT_EXCEPTION_UPDATE_INTERVAL = 20;
    public static final String CONTEXT_THREAD_CREATOR = "threadCreator";
    public static final String CONTEXT_TASK_COUNT = "taskCount";
    public static final String CONTEXT_THREAD_POOL = "threadPool";
    private int threadPoolSize = 10;
    private int throttleTaskCountThreshold = 100;
    private int spawnRetryPeriod = 3000;
    private String spawnedTaskId;

    public String getSpawnedTaskId() {
        return this.spawnedTaskId;
    }

    public void setSpawnedTaskId(String spawnedTaskId) {
        this.spawnedTaskId = spawnedTaskId;
    }

    public int getSpawnRetryPeriod() {
        return this.spawnRetryPeriod;
    }

    public void setSpawnRetryPeriod(int spawnRetryPeriod) {
        this.spawnRetryPeriod = spawnRetryPeriod;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getThrottleTaskCountThreshold() {
        return this.throttleTaskCountThreshold;
    }

    public void setThrottleTaskCountThreshold(int throttleTaskCountThreshold) {
        this.throttleTaskCountThreshold = throttleTaskCountThreshold;
    }

    public boolean beanCreationFailure(DataFileProcessExecutionContext context, String nextRowRawData, Exception e) {
        CampLejeuneImportProcessStatistics stats = (CampLejeuneImportProcessStatistics)context.getProcessStatistics();
        stats.incrementNumberOfErrorRecords();
        stats.addDetailUnsuccess(this.getIdData(context.getCurrentRowRawData()), e.getMessage());
        return true;
    }

    private String getIdData(String rawData) {
        if (StringUtils.isEmpty((String)rawData)) {
            return "";
        }
        String[] data = rawData.split("\\|");
        return new StringBuffer().append("|").append(data[3]).append("|").append(data[2]).append("|").append(data[5]).append("|").append(data[7]).append("|").append(data[8]).toString();
    }

    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null || acquiredData.isEmpty()) {
            return;
        }
        Object oLine = acquiredData.get(0);
        String sLine = null;
        if (oLine != null && (sLine = oLine.toString()).length() > 0 && sLine.contains("First_Name") && sLine.contains("Last_Name")) {
            acquiredData.remove(0);
        }
        this.spawnThread(context, acquiredData);
    }

    private void spawnThread(DataFileProcessExecutionContext context, List acquiredData) {
        this.initThreadCreatorAndIncrementTaskCount(context);
        ThreadPool threadPool = this.getThreadPool((DataProcessExecutionContext)context);
        CampLejeuneImportProcessSpawnedThreadTask task = (CampLejeuneImportProcessSpawnedThreadTask)((Object)this.getApplicationContext().getBean(this.spawnedTaskId));
        task.setContext(context);
        task.setAuditInfo(this.getAuditInfo());
        ArrayList taskData = new ArrayList();
        taskData.addAll(acquiredData);
        task.setDataRecords(taskData);
        threadPool.invokeLater((Runnable)((Object)task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        block9: {
            try {
                if (CampLejeuneImportProcess.getTaskCount(context) == 0) break block9;
                CampLejeuneImportProcess campLejeuneImportProcess = this;
                synchronized (campLejeuneImportProcess) {
                    boolean stillProcessing = true;
                    while (stillProcessing) {
                        ((Object)((Object)this)).wait();
                        if (CampLejeuneImportProcess.getTaskCount(context) != 0) continue;
                        stillProcessing = false;
                    }
                }
            }
            catch (InterruptedException e) {
                this.throwIllegalStateException("CampLejeuneImportProcess was interrupted while it was waiting for its spawned threads to complete", e);
            }
            finally {
                this.getThreadPool(context).stop();
                this.cleanThreadPool(context);
            }
        }
        super.handleDataProcessCompleted(context);
    }

    private void cleanThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = this.getThreadPool(context);
        threadPool.stop();
        context.getContextData().put(CONTEXT_THREAD_POOL, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"CampLejeuneImportProcessSpawnedThreadTask cleaned up the thread pool");
        }
    }

    private ThreadPool getThreadPool(DataProcessExecutionContext context) {
        ThreadPool threadPool = (ThreadPool)context.getContextData().get(CONTEXT_THREAD_POOL);
        if (threadPool == null) {
            threadPool = new ThreadPool("CampLejeuneImportProcessSpawnedThreadTask", this.threadPoolSize);
            context.getContextData().put(CONTEXT_THREAD_POOL, threadPool);
        }
        return threadPool;
    }

    private void initThreadCreatorAndIncrementTaskCount(DataFileProcessExecutionContext context) {
        if (!context.getContextData().containsKey(CONTEXT_THREAD_CREATOR)) {
            context.getContextData().put(CONTEXT_THREAD_CREATOR, this);
        }
        CampLejeuneImportProcess.adjustTaskCount((DataProcessExecutionContext)context, 1);
    }

    static int getTaskCount(DataProcessExecutionContext context) {
        Integer count = (Integer)context.getContextData().get(CONTEXT_TASK_COUNT);
        return count != null ? count : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void adjustTaskCount(DataProcessExecutionContext context, int adjustment) {
        DataProcessExecutionContext dataProcessExecutionContext = context;
        synchronized (dataProcessExecutionContext) {
            context.getContextData().put(CONTEXT_TASK_COUNT, new Integer(CampLejeuneImportProcess.getTaskCount(context) + adjustment));
        }
    }

    private boolean shouldWriteExceptionData(DataProcessExecutionContext context) {
        int exceptionDataSize;
        int n = exceptionDataSize = context.getExceptionData() == null ? 0 : context.getExceptionData().size();
        return exceptionDataSize != 0 ? exceptionDataSize % 20 == 0 : false;
    }

    protected ProcessStatistics createProcessStatistics() {
        return new CampLejeuneImportProcessStatistics();
    }
}

