/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.namingdirectory.client;

import gov.va.med.namingdirectory.NamingDirectoryRemote;
import gov.va.med.namingdirectory.client.Command;
import gov.va.med.soa.utils.enum.TechnologyType;
import gov.va.med.soa.utils.service.ServiceInfo;
import gov.va.med.soa.utils.service.ServiceInfoVO;
import gov.va.med.soa.utils.service.ServiceVersionVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class UpdateServiceCommand
extends Command {
    UpdateServiceCommand() {
    }

    public void run(NamingDirectoryRemote ndsRemote, String serviceProvider, String input) {
        String[] parameters = this.tokenizeInput(input);
        if (parameters == null || parameters.length == 0) {
            System.out.println("Specify service id");
        } else {
            try {
                int serviceId = Integer.parseInt(parameters[0]);
                ServiceInfoVO info = ndsRemote.retrieveServiceById(serviceId);
                boolean requestInput = true;
                while (requestInput) {
                    this.updateServiceInfo(info);
                    System.out.println(info.toString());
                    System.out.print("\nIs this information correct? (y-yes/n-no/x-cancel): ");
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String response = br.readLine();
                    if (response.equalsIgnoreCase("y")) {
                        requestInput = false;
                        continue;
                    }
                    if (!response.equalsIgnoreCase("x")) continue;
                    return;
                }
                info.setServiceProvider(serviceProvider);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public String helpMessage() {
        return "u <service id> - Updates the service with the new values";
    }

    private void updateServiceInfo(ServiceInfo info) throws IOException {
        String updatePrompt = "Update Service - ";
        System.out.println("Updating service.  Press enter to accept exiting values.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(updatePrompt + "Name [" + info.getName() + "]: ");
        String newName = br.readLine();
        if (newName.length() != 0) {
            info.setName(newName);
        }
        System.out.print(updatePrompt + "Description [" + info.getDescription() + "]: ");
        String newDesc = br.readLine();
        if (newDesc.length() != 0) {
            info.setDescription(newDesc);
        }
        System.out.print(updatePrompt + "Signature [" + info.getSignature() + "]: ");
        String newSignature = br.readLine();
        if (newSignature.length() != 0) {
            info.setSignature(newSignature);
        }
        ServiceVersionVO version = info.getVersion();
        System.out.print(updatePrompt + "Major Version [" + version.getMajorVersion() + "]: ");
        String newMajor = br.readLine();
        if (newMajor.length() != 0) {
            version.setMajorVersion(newMajor);
        }
        System.out.print(updatePrompt + "Minor Version [" + version.getMinorVersion() + "]: ");
        String newMinor = br.readLine();
        if (newMinor.length() != 0) {
            version.setMinorVersion(newMinor);
        }
        System.out.print(updatePrompt + "Revision Number [" + version.getRevisionNumber() + "]: ");
        String newRevision = br.readLine();
        if (newRevision.length() != 0) {
            version.setRevisionNumber(newRevision);
        }
        System.out.print(updatePrompt + "Build Number [" + version.getBuildNumber() + "]: ");
        String newBuild = br.readLine();
        if (newBuild.length() != 0) {
            version.setBuildNumber(newBuild);
        }
        System.out.print(updatePrompt + "Technology [" + info.getTechnology() + "]: ");
        String newTechnology = br.readLine();
        if (newTechnology.length() != 0) {
            TechnologyType techType = TechnologyType.fromString(newTechnology);
            info.setTechnology(techType);
        }
    }
}

