/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.namingdirectory.client;

import gov.va.med.namingdirectory.NamingDirectoryRemote;
import gov.va.med.namingdirectory.client.Command;
import gov.va.med.namingdirectory.client.LoadNDSData;
import gov.va.med.soa.utils.enum.TechnologyType;
import gov.va.med.soa.utils.service.ServiceInfoVO;
import gov.va.med.soa.utils.service.ServiceVersionVO;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.commons.digester.Digester;

class AddServicesCommand
extends Command {
    AddServicesCommand() {
    }

    public void run(NamingDirectoryRemote ndsRemote, String serviceProvider, String input) {
        String[] parameters = this.tokenizeInput(input);
        try {
            if (parameters == null || parameters.length == 0) {
                ServiceInfoVO info = new ServiceInfoVO();
                boolean requestInput = true;
                while (requestInput) {
                    info = new ServiceInfoVO();
                    this.retrieveServiceInfo(info);
                    System.out.println(info.toString());
                    System.out.print("\nIs this information correct? (y-yes/n-no/x-cancel): ");
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String response = br.readLine();
                    if (response.equalsIgnoreCase("y")) {
                        requestInput = false;
                        continue;
                    }
                    if (!response.equalsIgnoreCase("x")) continue;
                    return;
                }
                info.setServiceProvider(serviceProvider);
            } else {
                FileInputStream serviceFacadesFile = new FileInputStream(parameters[0]);
                LoadNDSData data = AddServicesCommand.loadFacadesFromXML(serviceFacadesFile);
                Iterator iter = data.getServices().iterator();
                while (iter.hasNext()) {
                    ServiceInfoVO info = (ServiceInfoVO)iter.next();
                    info.setServiceProvider(serviceProvider);
                    System.out.println(info.getName() + " added");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    public String helpMessage() {
        return "a [input file name] - Adds a service.  If the optional file name is specified, services defined in the file will be added";
    }

    private static LoadNDSData loadFacadesFromXML(InputStream xmlFile) throws Exception {
        LoadNDSData loadNDSData = new LoadNDSData();
        Digester digester = new Digester();
        digester.push((Object)loadNDSData);
        digester.addCallMethod("LoadNDS/ServiceFacades/ServiceFacade", "addService", 16);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Name", 0);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Description", 1);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/State", 2);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Technology", 3);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/MajorVersion", 4);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/MinorVersion", 5);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/RevisionNumber", 6);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/BuildNumber", 7);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Signature", 8);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Location", 9);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Provider", 10);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/URL", 11);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Principal", 12);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Credential", 13);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/FactoryLocation", 14);
        digester.addCallParam("LoadNDS/ServiceFacades/ServiceFacade/Priority", 15);
        try {
            digester.parse(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return loadNDSData;
    }

    private void retrieveServiceInfo(ServiceInfoVO info) throws IOException {
        String updatePrompt = "Adding a Service - ";
        System.out.println("Adding service.  Press enter to accept default/existing values.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(updatePrompt + "Name [" + info.getName() + "]: ");
        String newName = br.readLine();
        if (newName.length() != 0) {
            info.setName(newName);
        }
        System.out.print(updatePrompt + "Description [" + info.getDescription() + "]: ");
        String newDesc = br.readLine();
        if (newDesc.length() != 0) {
            info.setDescription(newDesc);
        }
        System.out.print(updatePrompt + "Signature [" + info.getSignature() + "]: ");
        String newSignature = br.readLine();
        if (newSignature.length() != 0) {
            info.setSignature(newSignature);
        }
        ServiceVersionVO version = info.getVersion();
        System.out.print(updatePrompt + "Major Version [" + version.getMajorVersion() + "]: ");
        String newMajor = br.readLine();
        if (newMajor.length() != 0) {
            version.setMajorVersion(newMajor);
        }
        System.out.print(updatePrompt + "Minor Version [" + version.getMinorVersion() + "]: ");
        String newMinor = br.readLine();
        if (newMinor.length() != 0) {
            version.setMinorVersion(newMinor);
        }
        System.out.print(updatePrompt + "Revision Number [" + version.getRevisionNumber() + "]: ");
        String newRevision = br.readLine();
        if (newRevision.length() != 0) {
            version.setRevisionNumber(newRevision);
        }
        System.out.print(updatePrompt + "Build Number [" + version.getBuildNumber() + "]: ");
        String newBuild = br.readLine();
        if (newBuild.length() != 0) {
            version.setBuildNumber(newBuild);
        }
        System.out.print(updatePrompt + "Technology [" + info.getTechnology() + "]: ");
        String newTechnology = br.readLine();
        if (newTechnology.length() != 0) {
            TechnologyType techType = TechnologyType.fromString(newTechnology);
            info.setTechnology(techType);
        }
    }
}

