/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.TaskQueue;

public class ThreadPool
extends AbstractComponent
implements Runnable {
    public static final int DEFAULT_NUMBER_OF_THREADS = 4;
    private TaskQueue queue = new TaskQueue();
    private boolean stopped = false;
    private int realizedThreadCount;
    private ThreadGroup threadGroup;

    public ThreadPool() {
        this(4);
    }

    public ThreadPool(int numberOfThreads) {
        this(null, numberOfThreads, 5);
    }

    public ThreadPool(String name, int numberOfThreads) {
        this(name, numberOfThreads, 5);
    }

    public ThreadPool(String name, int numberOfThreads, int threadPriority) {
        if (numberOfThreads <= 0 || threadPriority <= 0) {
            throw new IllegalArgumentException("Required parameters are not passed in");
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            this.startThread(name != null ? name + "-" + i : null, threadPriority);
            ++this.realizedThreadCount;
        }
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public void stop() {
        this.stopped = true;
        for (int i = 0; i < this.realizedThreadCount; ++i) {
            this.queue.add(new Runnable(){

                @Override
                public void run() {
                    ThreadPool.this.logger.info((Object)"ThreadPool sentinel Runnable instance encountered");
                }
            });
        }
    }

    public int getRunnableCount() {
        return this.queue.size();
    }

    public void invokeLater(Runnable task) {
        this.queue.add(task);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            Runnable task = (Runnable)this.queue.remove();
            if (task == null) continue;
            try {
                task.run();
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)"Failed to execute a task", t);
            }
        }
    }

    public void init() {
        this.queue.clearQueue();
    }

    protected Thread startThread() {
        Thread thread = this.createThread();
        thread.start();
        return thread;
    }

    protected Thread startThread(String name, int priority) {
        Thread thread = this.createThread();
        if (name != null) {
            thread.setName(name);
        }
        thread.setPriority(priority);
        thread.start();
        return thread;
    }

    protected Thread createThread() {
        if (this.threadGroup != null) {
            return new Thread(this.threadGroup, this);
        }
        return new Thread(this);
    }
}

