/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public abstract class AbstractContextAwareTestCase
extends AbstractDependencyInjectionSpringContextTests {
    private static final String DEFAULT_TEST_CONTEXT = "fw/test_components.xml";
    private String[] configLocations = new String[]{"fw/test_components.xml"};

    protected AbstractContextAwareTestCase() {
    }

    protected AbstractContextAwareTestCase(String name) {
        this.setName(name);
    }

    protected AbstractContextAwareTestCase(String[] configFiles) {
        this.initConfigLocations(configFiles, null);
    }

    protected AbstractContextAwareTestCase(String name, String[] configFiles) {
        this(name);
        this.initConfigLocations(configFiles, null);
    }

    protected AbstractContextAwareTestCase(String[] configFiles, String[] parentConfigFiles) {
        this.initConfigLocations(configFiles, parentConfigFiles);
    }

    protected AbstractContextAwareTestCase(String name, String[] configFiles, String[] parentConfigFiles) {
        this(name);
        this.initConfigLocations(configFiles, parentConfigFiles);
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    protected void fail(String message, Exception e) {
        e.fillInStackTrace();
        StringBuffer trace = new StringBuffer();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            trace.append("******").append(cause.getMessage()).append(" ").append(cause);
        }
        AbstractContextAwareTestCase.fail((String)(message + trace.toString()));
    }

    private void initConfigLocations(String[] configFiles, String[] parentConfigFiles) {
        int parentConfigFilesLength = 0;
        int configFilesLength = 0;
        if (parentConfigFiles != null) {
            parentConfigFilesLength = parentConfigFiles.length;
        }
        if (configFiles != null) {
            configFilesLength = configFiles.length;
        }
        String[] completeSetOfConfigFiles = new String[parentConfigFilesLength + configFilesLength];
        int index = 0;
        int i = 0;
        while (i < parentConfigFilesLength) {
            completeSetOfConfigFiles[index++] = parentConfigFiles[i++];
        }
        i = 0;
        while (i < configFilesLength) {
            completeSetOfConfigFiles[index++] = configFiles[i++];
        }
        this.configLocations = completeSetOfConfigFiles;
    }
}

