/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.taglib;

import gov.va.med.fw.util.StringUtils;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.taglib.TagUtils;
import org.apache.strutsel.taglib.utils.EvalHelper;

public class LabelTag
extends TagSupport {
    private static final long serialVersionUID = 7654954868896911653L;
    private String forId;
    private String property;
    private String styleClass;
    private boolean required = false;

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String prop) {
        this.property = prop;
        if (StringUtils.isNotEmpty((String)prop)) {
            try {
                String string = EvalHelper.evalString((String)"property", (String)prop, (Tag)this, (PageContext)this.pageContext);
                if (StringUtils.isNotEmpty((String)string)) {
                    this.property = string;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getRequired() {
        return String.valueOf(this.required);
    }

    public void setRequired(String required) {
        if (StringUtils.isNotEmpty((String)required)) {
            required = required.trim();
            try {
                String requiredEl = EvalHelper.evalString((String)"required", (String)required, (Tag)this, (PageContext)this.pageContext);
                if (StringUtils.isNotEmpty((String)requiredEl)) {
                    required = requiredEl;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (StringUtils.isEmpty((String)required)) {
            required = "false";
        }
        this.required = required.equalsIgnoreCase("true") || required.equalsIgnoreCase("yes");
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String style) {
        this.styleClass = style;
        if (StringUtils.isNotEmpty((String)style)) {
            try {
                String string = EvalHelper.evalString((String)"styleClass", (String)style, (Tag)this, (PageContext)this.pageContext);
                if (StringUtils.isNotEmpty((String)string)) {
                    this.styleClass = string;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int doStartTag() throws JspException {
        TagUtils util = TagUtils.getInstance();
        boolean tagInError = LabelTag.isTagInError(this.pageContext, this.getProperty());
        StringBuffer buffer = new StringBuffer();
        if ((this.required || tagInError) && tagInError) {
            String errorStyle = this.getStyleClass();
            if (StringUtils.isEmpty((String)errorStyle)) {
                errorStyle = util.message(this.pageContext, null, "org.apache.struts.action.LOCALE", "errors.label.errorStyle", null);
            }
            buffer.append("<span class=\"");
            buffer.append(errorStyle);
            buffer.append("\">");
            String errorLabelStart = util.message(this.pageContext, null, "org.apache.struts.action.LOCALE", "errors.label.prefix", null);
            buffer.append(errorLabelStart);
            buffer.append(" ");
        }
        buffer.append("<label for=\"" + (StringUtils.isNotEmpty((String)this.forId) ? this.forId : this.property) + "\">");
        if (this.required) {
            String requiredLabelStart = util.message(this.pageContext, null, "org.apache.struts.action.LOCALE", "label.required.prefix", null);
            buffer.append(requiredLabelStart);
            buffer.append(" ");
        }
        util.write(this.pageContext, buffer.toString());
        return 1;
    }

    public int doEndTag() throws JspException {
        TagUtils util = TagUtils.getInstance();
        util.write(this.pageContext, "</label>");
        if (LabelTag.isTagInError(this.pageContext, this.getProperty())) {
            util.write(this.pageContext, "</span>");
        }
        return 6;
    }

    public void release() {
        super.release();
    }

    private static boolean isTagInError(PageContext pageContext, String property) {
        String[] properties;
        Object value = pageContext.findAttribute("org.apache.struts.action.ERROR");
        if (value != null && (properties = property.split(",")) != null) {
            for (int i = 0; i < properties.length; ++i) {
                String oneProperty = properties[i];
                Iterator iter = ((ActionMessages)value).get(oneProperty);
                if (!iter.hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    public String getForId() {
        return this.forId;
    }

    public void setForId(String forId) {
        this.forId = forId;
    }
}

