/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.struts;

import gov.va.med.fw.conversion.ConversionService;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ActionValidation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.springframework.web.struts.LookupDispatchActionSupport;

public abstract class ServiceBrokerAction
extends LookupDispatchActionSupport
implements ActionValidation {
    protected ConversionService conversionService;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public ActionMessages validateAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    @Override
    public void failedValidationCallback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameter = mapping.getParameter();
        if (parameter == null) {
            String message = messages.getMessage("dispatch.handler", (Object)mapping.getPath());
            throw new ServletException(message);
        }
        String methodName = this.getMethodName(mapping, form, request, response, parameter);
        if (StringUtils.isNotEmpty((String)methodName)) {
            log.info((Object)"Dispatch method name is null or empty");
        }
        return this.dispatchMethod(mapping, form, request, response, methodName);
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        String methodName = null;
        if (StringUtils.isNotEmpty((String)parameter)) {
            if (this.getKeyMethodMap() != null) {
                log.info((Object)"Looking for a method whose name is specified in a map in a getKeyMethodMap method");
                methodName = super.getMethodName(mapping, form, request, response, parameter);
            } else {
                methodName = request.getParameter(parameter);
                if (StringUtils.isEmpty((String)methodName)) {
                    log.info((Object)"A request parameter was missing. Use a mapping parameter as a method name");
                    methodName = parameter;
                }
            }
        }
        return methodName;
    }

    protected Map getKeyMethodMap() {
        return null;
    }

    protected Map getApplicationData(HttpServletRequest request) {
        HttpSession session = request.getSession();
        HashMap appData = (HashMap)session.getAttribute("AppData");
        if (appData == null) {
            appData = new HashMap();
            session.setAttribute("AppData", appData);
        }
        return appData;
    }

    protected void updateSandbox(HttpServletRequest request, Map data) {
        Map sandbox = this.getSandbox(request);
        if (data != null) {
            sandbox.putAll(data);
        } else {
            sandbox.clear();
        }
    }

    protected void putSandboxEntry(HttpServletRequest request, Object key, Object value) {
        if (key != null && value != null) {
            this.getSandbox(request).put(key, value);
        }
    }

    protected Object getSandboxEntry(HttpServletRequest request, Object key) {
        return key != null ? this.getSandbox(request).get(key) : null;
    }

    protected Object removeSandboxEntry(HttpServletRequest request, Object key) {
        return key != null ? this.getSandbox(request).remove(key) : null;
    }

    protected void cleanSandbox(HttpServletRequest request) {
        this.getSandbox(request).clear();
    }

    protected Map getSandbox(HttpServletRequest request) {
        return this.getApplicationData(request);
    }

    protected void setSandbox(HttpServletRequest request, Map newSandbox) {
        this.updateSandbox(request, newSandbox);
    }

    public Log getLogger() {
        return this.logger;
    }
}

