/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.struts;

import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.ui.struts.ServiceBrokerAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;

public abstract class SecurityAction
extends ServiceBrokerAction {
    protected SecurityAction() {
    }

    protected void setSecurityContext(HttpServletRequest request, SecurityContext context) {
        this.putSandboxEntry(request, "SecurityContext", context);
    }

    protected SecurityContext getSecurityContext(HttpServletRequest request) {
        return (SecurityContext)this.getSandboxEntry(request, "SecurityContext");
    }

    public boolean isAllPermissionsGranted(List permissions) {
        ArrayList currentPermissions = new ArrayList(permissions);
        List grantedPermissions = this.getGrantedPermissions();
        currentPermissions.removeAll(grantedPermissions);
        return currentPermissions.size() <= 0;
    }

    public boolean isAnyPermissionGranted(List permissions) {
        List grantedPermissions = this.getGrantedPermissions();
        grantedPermissions.retainAll(permissions);
        return grantedPermissions.size() > 0;
    }

    public boolean isPermissionGranted(String permission) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(permission);
        return this.isAnyPermissionGranted(list);
    }

    public boolean isAnyPermissionGranted(String[] permissions) {
        ArrayList<String> list = new ArrayList<String>(permissions.length);
        for (int i = 0; i < permissions.length; ++i) {
            list.add(permissions[i]);
        }
        return this.isAnyPermissionGranted(list);
    }

    public boolean isAllPermissionsNotGranted(List permissions) {
        List grantedPermissions = this.getGrantedPermissions();
        grantedPermissions.retainAll(permissions);
        return grantedPermissions.size() <= 0;
    }

    protected List getGrantedPermissions() {
        return this.getPermissionsfromAuthorities(this.getAllGrantedAuthorities());
    }

    protected List getPermissionsfromAuthorities(List authorities) {
        ArrayList<String> permissions = new ArrayList<String>();
        Iterator i = authorities.iterator();
        while (i.hasNext()) {
            permissions.add(((GrantedAuthority)i.next()).getAuthority());
        }
        return permissions;
    }

    protected List getAllGrantedAuthorities() {
        org.acegisecurity.context.SecurityContext context = SecurityContextHolder.getContext();
        if (null == context) {
            return Collections.EMPTY_LIST;
        }
        Authentication currentUser = context.getAuthentication();
        if (null == currentUser) {
            return Collections.EMPTY_LIST;
        }
        if (null == currentUser.getAuthorities() || currentUser.getAuthorities().length < 1) {
            return Collections.EMPTY_LIST;
        }
        List<GrantedAuthority> granted = Arrays.asList(currentUser.getAuthorities());
        return granted;
    }

    protected UserPrincipal getLoggedInUser() {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        return securityContext != null ? securityContext.getUserPrincipal() : null;
    }
}

