/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.struts;

import gov.va.med.fw.ui.struts.ServiceBrokerAction;
import gov.va.med.fw.ui.struts.ServiceBrokerActionMapping;
import gov.va.med.fw.ui.struts.ServiceDelegatingActionProxy;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ActionValidation;
import gov.va.med.fw.validation.FormValidation;
import gov.va.med.fw.validation.ValidationFieldMessage;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.TilesRequestProcessor;

public class CustomRequestProcessor
extends TilesRequestProcessor {
    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        String input;
        ActionErrors errors;
        if (form == null) {
            return true;
        }
        if (request.getAttribute("org.apache.struts.action.CANCEL") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Cancelled transaction, skipping validation");
            }
            return true;
        }
        if (!mapping.getValidate()) {
            return true;
        }
        if (mapping instanceof ServiceBrokerActionMapping && !this.isMethodValidationEnabled(request, response, form, (ServiceBrokerActionMapping)mapping)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Validating input form properties");
        }
        if ((errors = form.validate(mapping, request)) == null || errors.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  No declarative validation errors detected, accepting input");
            }
            if ((errors = this.processFormAndActionValidation(request, response, form, mapping)) == null || errors.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  No custom/business validation errors detected, accepting input");
                }
                return true;
            }
        }
        if (form.getMultipartRequestHandler() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Rolling back multipart request");
            }
            form.getMultipartRequestHandler().rollback();
        }
        if ((input = mapping.getInput()) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Validation failed but no input form available");
            }
            response.sendError(500, this.getInternal().getMessage("noInput", (Object)mapping.getPath()));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Validation failed, returning to '" + input + "'"));
        }
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        Action action = this.processActionCreate(request, response, mapping);
        if (action instanceof ActionValidation) {
            ((ActionValidation)action).failedValidationCallback(mapping, form, request, response);
        }
        if (this.moduleConfig.getControllerConfig().getInputForward()) {
            ActionForward forward = mapping.findForward(input);
            super.processForwardConfig(request, response, (ForwardConfig)forward);
        } else {
            super.internalModuleRelativeForward(input, request, response);
        }
        return false;
    }

    private boolean isMethodValidationEnabled(HttpServletRequest request, HttpServletResponse response, ActionForm form, ServiceBrokerActionMapping mapping) throws IOException, ServletException {
        List methods = mapping.getValidateOnMethodList();
        if (methods == null || methods.size() == 0) {
            log.trace((Object)" Validate on method list is null or empty");
            return true;
        }
        log.trace((Object)(" Method list that needs validation " + methods));
        String parameter = mapping.getParameter();
        if (StringUtils.isEmpty((String)parameter)) {
            log.trace((Object)" action-mapping parameter is null/empty");
            return true;
        }
        Action action = this.processActionCreate(request, response, mapping);
        if (action instanceof ServiceDelegatingActionProxy) {
            action = ((ServiceDelegatingActionProxy)action).getDelegateAction(mapping);
        }
        if (action instanceof ServiceBrokerAction) {
            try {
                String methodName = ((ServiceBrokerAction)action).getMethodName(mapping, form, request, response, parameter);
                if (log.isTraceEnabled()) {
                    log.trace((Object)(" Check validation is enabled for method " + methodName));
                }
                if (StringUtils.isNotEmpty((String)methodName) && !methods.contains(methodName)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(" Validation is not enabled for method " + methodName));
                    }
                    return false;
                }
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        return true;
    }

    protected ActionMessages processFormAndActionValidation(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        ActionMessages actionErrors = null;
        if (form instanceof FormValidation) {
            actionErrors = ((FormValidation)form).validateForm(mapping, request);
        }
        if (actionErrors == null || actionErrors.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  No Form validation errors detected, accepting input");
            }
            Action action = this.processActionCreate(request, response, mapping);
            try {
                if (action instanceof ActionValidation) {
                    actionErrors = ((ActionValidation)action).validateAction(mapping, form, request, response);
                }
                if ((actionErrors == null || actionErrors.isEmpty()) && log.isTraceEnabled()) {
                    log.trace((Object)"  No Action validation errors detected, accepting input");
                }
            }
            catch (Exception ex) {
                log.error((Object)" Errors occured while performing business validation.", (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
        }
        return actionErrors;
    }

    protected ActionMessages convertValidationMessages(ValidationMessages validationMessages) throws Exception {
        ActionMessages actionMessages = null;
        if (validationMessages != null && !validationMessages.isEmpty()) {
            log.debug((Object)"Action validation messages exists.");
            actionMessages = new ActionMessages();
            Iterator iter = validationMessages.get();
            ValidationMessage validationError = null;
            ValidationFieldMessage validationFieldError = null;
            ActionMessage actionMessage = null;
            while (iter.hasNext()) {
                Object message = iter.next();
                if (message instanceof ValidationFieldMessage) {
                    validationFieldError = (ValidationFieldMessage)message;
                    actionMessage = new ActionMessage(validationFieldError.getKey(), validationFieldError.getValues());
                    actionMessages.add(validationFieldError.getFieldName(), actionMessage);
                    continue;
                }
                if (message instanceof ValidationMessage) {
                    validationError = (ValidationMessage)message;
                    actionMessage = new ActionMessage(validationError.getKey(), validationError.getValues());
                    actionMessages.add("global", actionMessage);
                    continue;
                }
                throw new Exception("Invalid object in ValidationErrors.");
            }
        }
        return actionMessages;
    }
}

