/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.filter;

import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.filter.WebSecurityFilter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String errorURL = null;
    private HttpServletResponse servletResponse = null;
    protected WebSecurityFilter webSecurityFilter;
    private static final int BUFFER_SIZE = 128;
    private static final String DEFAULT_BLACKLIST_PATTERN = "(.*\\.|^|.*|\\[('|\"))(c|C)lass(\\.|('|\")]|\\[).*";
    private static final String CONTENT_LENGTH_PATTERN = "(?i)content-length";
    private Pattern pattern = null;
    private Pattern content_length_pattern = null;
    private String body = null;
    private boolean read_stream = false;

    public WebSecurityFilter getWebSecurityFilter() {
        return this.webSecurityFilter;
    }

    public void setWebSecurityFilter(WebSecurityFilter webSecurityFilter) {
        this.webSecurityFilter = webSecurityFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSSRequestWrapper(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String errorURL) {
        super(servletRequest);
        this.servletResponse = servletResponse;
        this.errorURL = errorURL;
        if (this.pattern == null) {
            this.pattern = Pattern.compile(DEFAULT_BLACKLIST_PATTERN, 32);
        }
        if (this.content_length_pattern == null) {
            this.content_length_pattern = Pattern.compile(CONTENT_LENGTH_PATTERN, 32);
        }
        try {
            HttpServletRequest req = servletRequest;
            if (this.webSecurityFilter == null) {
                WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext(req.getSession().getServletContext());
                this.webSecurityFilter = (WebSecurityFilter)((Object)ac.getBean("webSecurityFilter"));
                this.setErrorPage(this.webSecurityFilter.getSsoErrorUrl());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to obtain an webSecurityFilter", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("XSSRequestWrapper : errorURL is " + errorURL));
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = servletRequest.getInputStream();
            if (inputStream != null) {
                String characterEncoding = this.getCharacterEncoding();
                bufferedReader = characterEncoding == null ? new BufferedReader(new InputStreamReader((InputStream)inputStream)) : new BufferedReader(new InputStreamReader((InputStream)inputStream, characterEncoding));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)"Error occured in XSSRequestWrapper ", (Throwable)ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)"Error occured in XSSRequestWrapper ", (Throwable)ex);
                }
            }
        }
        this.body = stringBuilder.toString();
    }

    public Enumeration getParameterNames() {
        ArrayList<String> finalParameterNames = new ArrayList<String>();
        ArrayList<String> parameterNames = Collections.list(super.getParameterNames());
        for (String parameterName : parameterNames) {
            if (this.pattern == null || this.pattern.matcher(parameterName).matches()) continue;
            finalParameterNames.add(parameterName);
        }
        return Collections.enumeration(finalParameterNames);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.stripXSS(values[i]);
        }
        return encodedValues;
    }

    public ServletInputStream getInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        if (this.pattern.matcher(this.body).matches()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"[getInputStream]: found body to match blacklisted parameter pattern");
            }
            byteArrayInputStream = new ByteArrayInputStream("".getBytes());
        } else if (this.read_stream) {
            byteArrayInputStream = new ByteArrayInputStream("".getBytes());
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"[getInputStream]: OK - body does not match blacklisted parameter pattern");
            }
            byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
            this.read_stream = true;
        }
        return new ServletInputStream(){

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.stripXSS(value);
    }

    public String getHeader(String name) {
        if (this.pattern != null && this.body != null && this.pattern.matcher(this.body).matches() && this.content_length_pattern.matcher(name).matches()) {
            return "0";
        }
        String value = super.getHeader(name);
        return this.stripXSS(value);
    }

    public int getContentLength() {
        if (this.pattern != null && this.body != null && this.pattern.matcher(this.body).matches()) {
            return 0;
        }
        return super.getContentLength();
    }

    private String stripXSS(String value) {
        if (value != null) {
            String orgValue = value;
            int orgValueLength = value.length();
            value = value.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            if (value.length() != orgValueLength) {
                this.logger.warn((Object)"Possible XSS Attack received");
                this.logger.warn((Object)("Value is stripped to " + value));
                try {
                    if (this.getErrorPage() != null) {
                        this.servletResponse.sendRedirect(this.getErrorPage());
                    }
                }
                catch (IOException ioe) {
                    this.logger.warn((Object)("Error occured when redirecting to Security Error Page is " + ioe.getMessage()));
                }
            }
        }
        return value;
    }

    public String getErrorPage() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getErrorPage errorURL is " + this.errorURL));
        }
        return this.errorURL;
    }

    public void setErrorPage(String errorURL) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setErrorPage errorURL is " + errorURL));
        }
        this.errorURL = errorURL;
    }
}

