/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.trigger;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerAware;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerRouterImpl
implements TriggerRouter {
    private Map triggerableServices;
    private TriggerableService defaultTriggerableService;
    protected Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processTriggerAware(TriggerAware triggerAware) throws ServiceException {
        boolean allRouted = false;
        if (triggerAware != null) {
            TriggerAware triggerAware2 = triggerAware;
            synchronized (triggerAware2) {
                Iterator itr;
                allRouted = true;
                Set triggerEvents = triggerAware.getTriggerEvents();
                Iterator iterator = itr = triggerEvents != null ? triggerEvents.iterator() : null;
                while (itr != null && itr.hasNext()) {
                    if (this.processTriggerEvent((TriggerEvent)itr.next())) continue;
                    allRouted = false;
                }
                triggerAware.clearTriggerEvents();
            }
        } else {
            this.logger.warn((Object)"Null TriggerAware object, ignoring");
        }
        return allRouted;
    }

    public Map getTriggerableServices() {
        return this.triggerableServices;
    }

    public void setTriggerableServices(Map triggerableServices) {
        this.triggerableServices = triggerableServices;
    }

    public void afterPropertiesSet() {
        if (this.triggerableServices == null) {
            throw new InvalidConfigurationException("Map of TriggerableService's must be set on " + this.getClass().getName());
        }
    }

    @Override
    public boolean processTriggerEvent(TriggerEvent triggerEvent) throws ServiceException {
        TriggerableService service = this.getTriggerableService(triggerEvent);
        if (service == null) {
            throw new InvalidConfigurationException(triggerEvent + " not mapped to a TriggerableService");
        }
        triggerEvent.preTriggerInit();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing " + service.getClass().getName() + " for TriggerEvent" + triggerEvent));
        }
        service.trigger(triggerEvent);
        return true;
    }

    protected TriggerableService getTriggerableService(TriggerEvent triggerEvent) {
        TriggerableService service = (TriggerableService)this.triggerableServices.get((Object)triggerEvent.getTriggerIdentity().getDestinationType());
        if (service == null) {
            service = this.defaultTriggerableService;
        }
        if (service == null) {
            throw new InvalidConfigurationException("Unable to route TriggerEvent, there is no TriggerableService defined for triggerEvent: " + triggerEvent);
        }
        return service;
    }

    public TriggerableService getDefaultTriggerableService() {
        return this.defaultTriggerableService;
    }

    public void setDefaultTriggerableService(TriggerableService defaultTriggerableService) {
        this.defaultTriggerableService = defaultTriggerableService;
    }
}

