/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.trigger;

import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.JMSServiceException;
import gov.va.med.fw.service.jms.QueueMessageProducer;
import gov.va.med.fw.service.trigger.PublishTriggerableService;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.util.InvalidConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueuePublishTriggerableServiceImpl
extends AbstractComponent
implements PublishTriggerableService {
    private QueueMessageProducer messageProducer;
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void trigger(TriggerEvent triggerEvent) throws ServiceException {
        this.publishMessage(triggerEvent);
    }

    protected void publishMessage(TriggerEvent triggerEvent) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("creating async message for TriggerEvent: " + triggerEvent));
        }
        if (triggerEvent.getTriggerIdentity() == null || triggerEvent.getTriggerIdentity().getDestinationType() == null) {
            throw new IllegalStateException("A TriggerEvent must have a non-null getTriggerIdentity().getDestinationType()");
        }
        if (triggerEvent.getInitiater() == null) {
            try {
                triggerEvent.setInitiater(SecurityContextHelper.getSecurityContext().getUserPrincipal().getUserCredentials());
            }
            catch (Exception e) {
                this.logger.warn((Object)"At publish time, unable to set TriggerEvent.initiater, most likely because the user is no longer logged in.", (Throwable)e);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Publishing TriggerEvent context: " + triggerEvent.getTriggerContext() + " for TriggerEvent identity: " + triggerEvent.getTriggerIdentity()));
        }
        try {
            this.messageProducer.send(triggerEvent, triggerEvent.getRoutingProperties());
        }
        catch (JMSServiceException e) {
            this.logger.error((Object)("!! Unable to publish TriggerEvent [" + triggerEvent + "]."));
            throw e;
        }
    }

    public QueueMessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    public void setMessageProducer(QueueMessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.messageProducer == null) {
            throw new InvalidConfigurationException("MessageProducer must be set on " + this.getClass().getName());
        }
    }

    @Override
    public void publishTriggerEvent(TriggerEvent triggerEvent) throws ServiceException {
        this.publishMessage(triggerEvent);
    }
}

