/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.cache.TransactionTimestampCacheManager;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.CurrentTimestampAction;
import gov.va.med.fw.service.AbstractComponent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TransactionTimestampManager
extends AbstractComponent {
    private TransactionTimestampCacheManager timestampCacheManager;
    private CurrentTimestampAction currentTimestampAction;
    private String daoName;
    private static DAOOperations dao;

    public Timestamp intializeTransactionTimestamp(boolean forceOverride) {
        if (this.timestampCacheManager.hasTimestamp() && forceOverride) {
            this.timestampCacheManager.removeTimestamp();
        }
        Timestamp ts = this.createNewTransactionTimestamp();
        this.timestampCacheManager.storeTransactionTimestamp(ts);
        return ts;
    }

    public Timestamp getTransactionTimestamp() {
        Timestamp ts = this.timestampCacheManager.getTransactionTimestamp();
        if (ts == null) {
            this.logger.debug((Object)"There is no Timestamp tied to the current (if any) Transaction. Creating new one");
            ts = this.createNewTransactionTimestamp();
        }
        return ts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Timestamp createNewTransactionTimestamp() {
        Timestamp ts = null;
        if (this.currentTimestampAction != null) {
            try {
                List results = (List)this.getDao().execute(this.currentTimestampAction);
                ts = (Timestamp)results.get(0);
                if (!this.logger.isDebugEnabled()) return ts;
                this.logger.debug((Object)("###Initialized ts (from Database) at JVM time [" + new Date() + "]: using database ts [" + ts + "]"));
                return ts;
            }
            catch (DAOException e) {
                this.logger.error((Object)"Can not retrieve current timestamp from database", (Throwable)e);
                IllegalStateException e2 = new IllegalStateException("EntityInterceptor is in an illegal state and was unable to retrieve current timestamp from database");
                e2.initCause(e);
                throw e2;
            }
        } else {
            ts = new Timestamp(System.currentTimeMillis());
            if (!this.logger.isDebugEnabled()) return ts;
            this.logger.debug((Object)("###Initialized ts (from JVM) at JVM time [" + new Date() + "]: using jvm ts [" + ts + "]"));
        }
        return ts;
    }

    public TransactionTimestampCacheManager getTimestampCacheManager() {
        return this.timestampCacheManager;
    }

    public void setTimestampCacheManager(TransactionTimestampCacheManager timestampCacheManager) {
        this.timestampCacheManager = timestampCacheManager;
    }

    public CurrentTimestampAction getCurrentTimestampAction() {
        return this.currentTimestampAction;
    }

    public void setCurrentTimestampAction(CurrentTimestampAction currentTimestampAction) {
        this.currentTimestampAction = currentTimestampAction;
    }

    public String getDaoName() {
        return this.daoName;
    }

    public void setDaoName(String daoName) {
        this.daoName = daoName;
    }

    public DAOOperations getDao() {
        if (dao == null) {
            dao = (DAOOperations)this.getApplicationContext().getBean(this.daoName, DAOOperations.class);
        }
        return dao;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.timestampCacheManager);
        if (this.currentTimestampAction != null) {
            Validate.notNull((Object)this.daoName, (String)"daoName property can not be null when getting current time from database");
        }
    }
}

