/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.springframework.transaction.support.TransactionSynchronization;

public class TransactionSynchronizationForEvents
extends AbstractComponent
implements TransactionSynchronization {
    private TriggerRouter triggerRouter;
    private TriggerEventCacheManager cacheManager;
    private boolean supportsDistributedTransactions;
    private Set triggerEvents;
    private int ROUTE_NOW = 0;

    public void suspend() {
        if (this.cacheManager.hasTriggerEvents()) {
            this.triggerEvents = this.cacheManager.removeTriggerEvents();
        }
    }

    public void resume() {
        if (this.triggerEvents != null) {
            this.cacheManager.storeTriggerEvents(this.triggerEvents);
        }
    }

    public void beforeCommit(boolean readOnly) {
        if (this.supportsDistributedTransactions) {
            this.routeEvents(this.cacheManager.removeTriggerEvents(), this.ROUTE_NOW);
        }
    }

    public void afterCommit() {
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        Set events = this.cacheManager.removeTriggerEvents();
        if (!this.supportsDistributedTransactions) {
            this.routeEvents(events, status);
        }
    }

    private void routeEvents(Set events, int transactionStatus) {
        if (transactionStatus == this.ROUTE_NOW) {
            Iterator itr = events != null ? events.iterator() : null;
            TriggerEvent event = null;
            try {
                while (itr != null && itr.hasNext()) {
                    event = (TriggerEvent)itr.next();
                    this.triggerRouter.processTriggerEvent(event);
                }
            }
            catch (ServiceException e) {
                IllegalStateException wrapped = new IllegalStateException("Was unable to route TriggerEvents");
                wrapped.initCause(e);
                throw wrapped;
            }
        }
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerRouter);
        Validate.notNull((Object)this.cacheManager);
    }

    public TriggerEventCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(TriggerEventCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean isSupportsDistributedTransactions() {
        return this.supportsDistributedTransactions;
    }

    public void setSupportsDistributedTransactions(boolean supportsDistributedTransactions) {
        this.supportsDistributedTransactions = supportsDistributedTransactions;
    }
}

