/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.cache.CacheManager;
import gov.va.med.fw.service.AbstractComponent;
import org.apache.commons.lang.Validate;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionSynchronizationForCacheManager
extends AbstractComponent
implements TransactionSynchronization {
    public static final String CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION = TransactionSynchronizationForCacheManager.class.getName() + ".autoCleanup";
    private CacheManager cacheManager = null;

    public void suspend() {
        if (TransactionSynchronizationManager.hasResource((Object)CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION)) {
            TransactionSynchronizationManager.unbindResource((Object)CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION);
        }
    }

    public void resume() {
        if (!TransactionSynchronizationManager.hasResource((Object)CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION)) {
            TransactionSynchronizationManager.bindResource((Object)CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION, (Object)Boolean.TRUE.toString());
        }
    }

    public void beforeCommit(boolean readOnly) {
    }

    public void beforeCompletion() {
        String txName = TransactionSynchronizationManager.getCurrentTransactionName();
        if (txName != null) {
            this.getCacheManager().removeItem(txName);
            if (TransactionSynchronizationManager.hasResource((Object)CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION)) {
                TransactionSynchronizationManager.unbindResource((Object)CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION);
            }
        }
    }

    public void afterCompletion(int status) {
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.cacheManager, (String)"A cacheManager is required");
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

