/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.support;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.util.Assert;

public abstract class AbstractRunnableService
extends AbstractComponent
implements Runnable {
    private ArrayList services = null;

    protected AbstractRunnableService() {
    }

    public ArrayList getServices() {
        return this.services;
    }

    public void setServices(ArrayList services) {
        this.services = services;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.getServices(), (String)"Missing a required list of services to be executed");
        this.execute();
    }

    @Override
    public void run() {
        Iterator i = this.services.iterator();
        while (i.hasNext()) {
            try {
                Object service = i.next();
                if (!(service instanceof Runnable)) continue;
                ((Runnable)service).run();
            }
            catch (Exception e) {
                this.logger.debug((Object)"Exception in running a service ", (Throwable)e);
            }
        }
    }

    protected abstract void execute() throws ServiceException;
}

