/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.AbstractMessageDescriptor;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;

public class TopicDescriptor
extends AbstractMessageDescriptor {
    private String topicName = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.topicName == null) {
            throw new ServiceException("Missing properties: topicName");
        }
    }

    public void setTopicName(String name) {
        this.topicName = name;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public TopicConnectionFactory getConnectionFactory(String providerURL) throws ServiceException {
        return (TopicConnectionFactory)this.getConnectionFactory(providerURL, this.getFactoryName(), TopicConnectionFactory.class);
    }

    public Topic getTopic(String providerURL) throws ServiceException {
        return (Topic)this.getDestination(providerURL, this.getTopicName(), Topic.class);
    }

    public TopicConnection createTopicConnection(String providerURL) throws ServiceException {
        return this.createTopicConnection(this.getConnectionFactory(providerURL));
    }

    public TopicConnection createTopicConnection(TopicConnectionFactory factory) throws ServiceException {
        TopicConnection connection = null;
        try {
            connection = factory.createTopicConnection();
            connection.start();
        }
        catch (JMSException e) {
            throw new ServiceException("Failed to create a connection", e);
        }
        return connection;
    }

    public TopicSession createTopicSession(TopicConnection connection, boolean transacted, int mode) throws ServiceException {
        TopicSession session = null;
        try {
            session = connection.createTopicSession(transacted, mode);
        }
        catch (JMSException e) {
            throw new ServiceException("Failed to create a session", e);
        }
        return session;
    }

    public TopicSession createTopicSession(TopicConnection connection) throws ServiceException {
        return this.createTopicSession(connection, true, 1);
    }
}

