/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.event.Asynchronous;
import gov.va.med.fw.service.event.ServiceEvent;
import gov.va.med.fw.util.ThreadPool;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractListenerService
extends AbstractComponent
implements ApplicationListener {
    private ThreadPool pool = null;

    public ThreadPool getPool() {
        return this.pool;
    }

    public void setPool(ThreadPool pool) {
        this.pool = pool;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ServiceEvent) {
            ServiceEvent serviceEvent = (ServiceEvent)event;
            if (serviceEvent instanceof Asynchronous && this.pool != null) {
                this.pool.invokeLater(new Processor(serviceEvent));
            } else {
                this.processServiceEvent((ServiceEvent)event);
            }
        }
    }

    protected abstract void processServiceEvent(ServiceEvent var1);

    private class Processor
    implements Runnable {
        private ServiceEvent asynchEvent = null;

        Processor(ServiceEvent event) {
            this.asynchEvent = event;
        }

        @Override
        public void run() {
            AbstractListenerService.this.processServiceEvent(this.asynchEvent);
        }
    }
}

