/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security;

import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.security.AuthenticationObject;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.security.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;

public class SecurityContextHelper {
    public static SecurityContext getSecurityContext() {
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof org.acegisecurity.context.SecurityContext)) {
            throw new IllegalStateException("SecurityContext invalid: [" + SecurityContextHolder.getContext() + " context]. Probably not yet logged in.");
        }
        org.acegisecurity.context.SecurityContext sc = SecurityContextHolder.getContext();
        Authentication authToken = sc.getAuthentication();
        if (authToken != null) {
            if (authToken instanceof AuthenticationObject) {
                AuthenticationObject auth = (AuthenticationObject)authToken;
                if (!auth.isLoggedIn()) {
                    throw new IllegalStateException("SecurityContext invalid: Not yet logged in");
                }
                auth.getUserPrincipal().getUserCredentials().setVerified(true);
                return new SecurityContext(auth.getUserPrincipal(), auth.getAuthorities(), auth.getDetails());
            }
            Object prin = authToken.getPrincipal();
            if (prin instanceof String) {
                prin = new UserPrincipalImpl((String)prin);
            }
            return new SecurityContext((UserPrincipal)prin, authToken.getAuthorities(), null);
        }
        throw new IllegalStateException("SecurityContext invalid: [" + authToken + " Authentication Object]. Not yet logged in.");
    }

    public static SecurityContext getSecurityContext(HttpServletRequest request) {
        return SecurityContextHelper.getSecurityContext();
    }

    public static UserPrincipal getCurrentUser() {
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof org.acegisecurity.context.SecurityContext)) {
            throw new IllegalStateException("SecurityContext invalid: [" + SecurityContextHolder.getContext() + " context]. Probably not yet logged in.");
        }
        org.acegisecurity.context.SecurityContext sc = SecurityContextHolder.getContext();
        Authentication authToken = sc.getAuthentication();
        if (authToken != null) {
            if (authToken instanceof AuthenticationObject) {
                AuthenticationObject auth = (AuthenticationObject)authToken;
                if (!auth.isLoggedIn()) {
                    throw new IllegalStateException("SecurityContext invalid: Not yet logged in");
                }
                auth.getUserPrincipal().getUserCredentials().setVerified(true);
                return auth.getUserPrincipal();
            }
            Object prin = authToken.getPrincipal();
            if (prin instanceof String) {
                prin = new UserPrincipalImpl((String)prin);
            }
            return (UserPrincipal)prin;
        }
        throw new IllegalStateException("SecurityContext invalid: [" + authToken + " Authentication Object]. Not yet logged in.");
    }

    public static String getUserName(UserPrincipal userPrincipal) {
        if (userPrincipal != null) {
            return SecurityContextHelper.getUserName(userPrincipal.getUserCredentials());
        }
        return null;
    }

    public static String getUserName(UserCredentials cred) {
        if (cred != null) {
            return cred.getLogicalID() != null ? cred.getLogicalID() : cred.getUserID();
        }
        return null;
    }

    public static String getUserName() {
        SecurityContext context = SecurityContextHelper.getSecurityContext();
        UserPrincipal prin = context != null ? context.getUserPrincipal() : null;
        return SecurityContextHelper.getUserName(prin);
    }

    public static List getGrantedPermissions() {
        org.acegisecurity.context.SecurityContext context = SecurityContextHolder.getContext();
        if (null == context) {
            return Collections.EMPTY_LIST;
        }
        Authentication currentUser = context.getAuthentication();
        if (currentUser == null || currentUser.getAuthorities() == null || currentUser.getAuthorities().length < 1) {
            return Collections.EMPTY_LIST;
        }
        GrantedAuthority[] authorities = currentUser.getAuthorities();
        int count = authorities.length;
        ArrayList<String> permissions = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            permissions.add(authorities[i].getAuthority());
        }
        return permissions;
    }

    public static boolean isAnyPermissionGranted(String[] permissions) {
        ArrayList<String> list = new ArrayList<String>(permissions.length);
        for (int i = 0; i < permissions.length; ++i) {
            list.add(permissions[i]);
        }
        return SecurityContextHelper.isAnyPermissionGranted(list);
    }

    public static boolean isAnyPermissionGranted(List permissions) {
        List grantedPermissions = SecurityContextHelper.getGrantedPermissions();
        grantedPermissions.retainAll(permissions);
        return grantedPermissions.size() > 0;
    }

    public static void initSecurityContextOnThread(LoginManager loginManager, UserCredentials cred) throws LoginException {
        if (cred != null && cred.isAnonymous()) {
            loginManager.loginAnonymous(cred.getLogicalID());
        } else {
            loginManager.loginAnonymous();
        }
        if (cred != null && !cred.isAnonymous()) {
            loginManager.login(cred);
        }
    }
}

