/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.InvalidConfigurationException;

public abstract class AbstractScheduledProcess
extends AbstractComponent
implements ScheduledProcess {
    private String auditId;
    boolean interrupted = false;

    @Override
    public final void invoke() throws Exception {
        this.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(ScheduledProcessInvocationContext context) throws Exception {
        try {
            if (this.isInterrupted()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("This ScheduledProcess [" + this.getAuditInfo() + "] is still in an interrupted state...." + "Please wait until it detects this and aborts before trying to execute again."));
                }
            } else {
                this.executeProcess(context);
            }
        }
        finally {
            this.setInterrupted(false);
        }
    }

    @Override
    public void interrupt() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("This ScheduledProcess [" + this.getAuditInfo() + "] received an interruption request"));
        }
        this.setInterrupted(true);
    }

    @Override
    public String getAuditInfo(ScheduledProcessInvocationContext context) {
        return this.getAuditInfo();
    }

    public String getAuditInfo() {
        String auditInfo = this.auditId != null ? "Job-" + this.auditId : "Job-Unspecified";
        return auditInfo;
    }

    protected abstract void executeProcess(ScheduledProcessInvocationContext var1) throws Exception;

    public String getAuditId() {
        return this.auditId;
    }

    public void setAuditId(String auditId) {
        this.auditId = auditId;
    }

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    protected void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    @Override
    public void afterPropertiesSet() {
        try {
            super.afterPropertiesSet();
        }
        catch (Exception e) {
            InvalidConfigurationException e1 = new InvalidConfigurationException("Invalid configuration for instance of AbstractScheduledProcess");
            e1.initCause(e);
            throw e1;
        }
    }
}

