/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerAware;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.springframework.aop.AfterReturningAdvice;

public class RuleFlowInterceptor
extends AbstractComponent
implements AfterReturningAdvice {
    private TriggerRouter triggerRouter;

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof RuleParameters) {
                this.postProcess((RuleParameters)args[i]);
                continue;
            }
            if (!(args[i] instanceof RuleParameter)) continue;
            this.postProcess((RuleParameter)args[i]);
        }
    }

    private void postProcess(RuleParameters ruleParameters) throws ServiceException {
        Iterator itr;
        Map params = ruleParameters.getRuleParameters();
        Iterator iterator = itr = params != null ? params.values().iterator() : null;
        while (itr != null && itr.hasNext()) {
            this.postProcess((RuleParameter)itr.next());
        }
    }

    private void postProcess(RuleParameter ruleParameter) throws ServiceException {
        if (ruleParameter instanceof TriggerAware) {
            this.getTriggerRouter().processTriggerAware((TriggerAware)((Object)ruleParameter));
        }
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.triggerRouter == null) {
            throw new RuleConfigurationException("A TriggerRouter is necessary for RuleFlow interception");
        }
    }
}

