/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.jasperreport;

import gov.va.med.fw.report.AbstractReportExporter;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportTemplate;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.jasperreport.data.JasperReportData;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import org.apache.commons.lang.Validate;

public abstract class AbstractJasperReportExporter
extends AbstractReportExporter {
    private static final long serialVersionUID = -856131465569866311L;
    private boolean asynchronous = false;
    private LoginManager loginManager = null;

    protected AbstractJasperReportExporter() {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.asynchronous) {
            Validate.notNull((Object)this.loginManager, (String)"A login manager is missing");
        }
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    @Override
    public void exportReport(ReportConfiguration config, ReportData data, ReportTemplate template) throws ReportException {
        if (!this.isAsynchronous()) {
            super.exportReport(config, data, template);
        } else {
            try {
                AsynchronousFillHandle handle = AsynchronousFillHandle.createHandle((JasperReport)this.getJasperReport(config, template), (Map)config.getResourceMapping(), (JRDataSource)this.getJasperDataSource(data));
                ExportHandler handler = new ExportHandler(config, this);
                handle.addListener((AsynchronousFilllListener)handler);
                handle.startFill();
            }
            catch (JRException e) {
                throw new ReportException("Failed to populate a report asynchronously", e);
            }
        }
    }

    @Override
    protected Object fill(ReportConfiguration config, ReportData data, ReportTemplate template) throws ReportException {
        Validate.notNull((Object)template, (String)"A report template must not be NULL ");
        JasperPrint report = null;
        try {
            report = JasperFillManager.fillReport((JasperReport)this.getJasperReport(config, template), (Map)config.getResourceMapping(), (JRDataSource)this.getJasperDataSource(data));
        }
        catch (JRException e) {
            throw new ReportException("Failed to populate a report ", e);
        }
        return report;
    }

    @Override
    protected ByteArrayOutputStream export(Object report) throws ReportException {
        if (!(report instanceof JasperPrint)) {
            throw new ReportException("Invalid report type to export: " + report);
        }
        return this.exportJasperReport(null, (JasperPrint)report);
    }

    protected JasperReport getJasperReport(ReportConfiguration config, ReportTemplate template) throws ReportException {
        JasperReport jasperReport;
        Object tpl = template.getCompiledTemplate(config);
        JasperReport jasperReport2 = jasperReport = tpl instanceof JasperReport ? (JasperReport)tpl : null;
        if (jasperReport == null) {
            throw new ReportException("Invalid type or missing report template: " + jasperReport);
        }
        return jasperReport;
    }

    protected JRDataSource getJasperDataSource(ReportData data) throws ReportException {
        JRDataSource jasperData;
        JasperReportData reportData = data instanceof JasperReportData ? (JasperReportData)data : null;
        JRDataSource jRDataSource = jasperData = reportData != null ? reportData.getJasperDataSource() : null;
        if (jasperData == null) {
            throw new ReportException("Invalid type of report data " + jasperData);
        }
        return jasperData;
    }

    protected abstract ByteArrayOutputStream exportJasperReport(ReportConfiguration var1, JasperPrint var2) throws ReportException;

    protected class ExportHandler
    implements AsynchronousFilllListener {
        private ReportConfiguration config = null;
        private AbstractJasperReportExporter exporter = null;

        protected ExportHandler(ReportConfiguration config, AbstractJasperReportExporter exporter) {
            this.config = config;
            this.exporter = exporter;
        }

        public void reportFinished(JasperPrint jasperPrint) {
            try {
                UserPrincipal user = this.config.getReportUser();
                if (user != null) {
                    SecurityContextHelper.initSecurityContextOnThread(this.exporter.loginManager, user.getUserCredentials());
                }
                this.exporter.persist(this.config, this.exporter.exportJasperReport(this.config, jasperPrint));
            }
            catch (Exception e) {
                this.reportFillError(e);
            }
        }

        public void reportCancelled() {
            if (AbstractJasperReportExporter.this.logger.isInfoEnabled()) {
                AbstractJasperReportExporter.this.logger.info((Object)"A report generation is canceled");
                AbstractJasperReportExporter.this.logger.info((Object)("A report configuration: " + this.config));
            }
        }

        public void reportFillError(Throwable t) {
            if (AbstractJasperReportExporter.this.logger.isInfoEnabled()) {
                AbstractJasperReportExporter.this.logger.info((Object)"Failed to fill / to export a report due to: ", t);
            }
        }
    }
}

